/************************************************************
 *
 * 1999 - 2004 (c) Intersect Alliance Pty Ltd.
 *
 * These routines read the audit config file, and populates
 * the audit configuration window, when called.
 *
 *
 * SNARE GUI Version 2.4
 *
 ************************************************************/
#define MAX_HOSTID				256
#define MAX_AUDIT_CONFIG_LINE   8192
#define SMALL_TOKEN_SIZE        64
#define TOKEN_SIZE		256
#define LARGE_TOKEN_SIZE	1024
#define BUFR_SIZE		8192

#define CONFIG_FILENAME "/etc/security/snare.conf"
#define PID_FILENAME "/var/run/snarecore.pid"

#define MATCH_PARTIAL 		1
#define MATCH_EXACT   		2
#define MATCH_REGEXP  		3
#define MATCH_SELECTED  	4
#define MATCH_ALL       	5
#define MATCH_EXCLUDE		6

#define CONFIG_AUDITTYPE        1
#define CONFIG_OBJECTIVES       2
#define CONFIG_REMOTE           3
#define CONFIG_OUTPUT   	4
#define CONFIG_HOSTID   	5


#define EVENT_OFF	        0
#define EVENT_ON	        1

#define RETURNCODE_FAILURE	0
#define RETURNCODE_SUCCESS	1
#define RETURNCODE_ANY		2

#define READ_TYPE_FROM_STRUCT   0
#define AUDIT_CHANGE	        1
#define AUDIT_NO_CHANGE         2
#define AUDIT_TO_NETWORK	3
#define AUDIT_BY_OBJECTIVE	4
#define AUDIT_BY_EVENT		5

#define CRITICALITY_CLEAR       0
#define CRITICALITY_INFO        1
#define CRITICALITY_WARNING 		2
#define CRITICALITY_PRIORITY 	3
#define CRITICALITY_CRITICAL 	4

#define CRITICALITY_CLEAR_CHAR      "0"
#define CRITICALITY_INFO_CHAR       "1"
#define CRITICALITY_WARNING_CHAR 	"2"
#define CRITICALITY_PRIORITY_CHAR 	"3"
#define CRITICALITY_CRITICAL_CHAR 	"4"

gint read_configuration(GtkWidget *);
gint set_raw_events(GtkWidget *, int);
void trim(char *);
void trimallwhitespace(char *);
int splitobjective(char *, char *, char *, char *, int *, int *);
int getaudittype(char *);
int getheader(char *);
int isaudittype(char *);
int isfilename(char *);
int isheader(char *);
int iscomment(char *);
int regmatch(const char *, const char *);
int regmatchi(const char *, const char *);
int GetMatch(const char *, char *);
int GetMatchUser(const char *, char *);
char *gethostident(char *, char *, int);
int isnetwork(char *);
int isipaddress(char *);
int iswebport(char *);
int ispassword(char *);
int isremotecontrol(char *);
