/************************************************************
 *
 * 1999 - 2004 (c) Intersect Alliance Pty Ltd.
 *
 * These routines support the reading of the event log file,
 * management of the log file, and drawing the pixmaps
 *
 *
 * SNARE GUI Version 2.4
 *
 ************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gnome.h>

#include "write_objective.h"
#include "read_config.h"
#include "support.h"
#include "callbacks.h"


gint write_objective(GtkWidget * obj_clist, GtkWidget * obj_window,
		     GtkTreeIter iter, int add_or_change)
{
	gchar alert[TOKEN_SIZE] = "NULL", success[TOKEN_SIZE] =
	    "NULL", events[TOKEN_SIZE] = "NULL";
	gchar filter_match[TOKEN_SIZE] = "NULL", user_match[TOKEN_SIZE] =
	    "NULL";
	gchar filter_expression[MAX_AUDIT_CONFIG_LINE] = "NULL";
	gchar user_expression[MAX_AUDIT_CONFIG_LINE] = "NULL";
	gchar *line[7] =
	    { alert, success, user_match, user_expression, filter_match,
       filter_expression, events };
	GtkListStore *model;
	gboolean iter_result = FALSE;

	read_success_level(obj_window, success);
	read_alert_level(obj_window, alert);
	read_user_match_level(obj_window, user_match);
	read_filter_match_level(obj_window, filter_match);
	read_raw_events(obj_window, events);
	read_user_match_exp(obj_window, user_expression);
	read_filter_match_exp(obj_window, filter_expression);

	model =
	    GTK_LIST_STORE(gtk_tree_view_get_model
			   (GTK_TREE_VIEW(obj_clist)));


	if (add_or_change == ADD) {
		gtk_list_store_append(model, &iter);
		gtk_list_store_set(model, &iter, 0, alert, 1, success, 2,
				   user_match, 3, user_expression, 4,
				   filter_match, 5, filter_expression, 6,
				   events, -1);
	} else if (add_or_change == CHANGE) {
		gtk_list_store_set(model, &iter, 0, alert, 1, success, 2,
				   user_match, 3, user_expression, 4,
				   filter_match, 5, filter_expression, 6,
				   events, -1);
	} else
		return FALSE;

	return TRUE;
}



void read_success_level(GtkWidget * obj_window, gchar * success)
{
	GtkWidget *success_radio, *failure_radio;

	success_radio = lookup_widget(obj_window, "succ_radio");
	failure_radio = lookup_widget(obj_window, "fail_radio");

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(success_radio)))
		strcpy(success, "Success");
	else if (gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON(failure_radio)))
		strcpy(success, "Failure");
	else
		strcpy(success, "Success & Failure");
}

void read_alert_level(GtkWidget * obj_window, gchar * alert)
{
	GtkWidget *critic_radio, *pri_radio, *warn_radio, *info_radio;

	critic_radio = lookup_widget(obj_window, "critic_radio");
	pri_radio = lookup_widget(obj_window, "pri_radio");
	warn_radio = lookup_widget(obj_window, "warn_radio");
	info_radio = lookup_widget(obj_window, "info_radio");

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(critic_radio)))
		strcpy(alert, "Critical");
	else if (gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON(pri_radio)))
		strcpy(alert, "Priority");
	else if (gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON(warn_radio)))
		strcpy(alert, "Warning");
	else if (gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON(info_radio)))
		strcpy(alert, "Information");
	else
		strcpy(alert, "Clear");
}


void read_user_match_level(GtkWidget * obj_window, gchar * user_match)
{
	GtkWidget *selusers_radio;
	GtkWidget *otherusers_radio;

	selusers_radio = lookup_widget(obj_window, "selusers_radio");
	otherusers_radio = lookup_widget(obj_window, "otherusers_radio");

	if (gtk_toggle_button_get_active
	    (GTK_TOGGLE_BUTTON(selusers_radio)))
		strcpy(user_match, "Selected");
	else if (gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON(otherusers_radio)))
		strcpy(user_match, "Exclude");
	else
		strcpy(user_match, "All");
}

void read_filter_match_level(GtkWidget * obj_window, gchar * filter_match)
{
	GtkWidget *full_radio, *partial_radio;

	full_radio = lookup_widget(obj_window, "full_radio");
	partial_radio = lookup_widget(obj_window, "partial_radio");

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(full_radio)))
		strcpy(filter_match, "Full");
	else if (gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON(partial_radio)))
		strcpy(filter_match, "Partial");
	else
		strcpy(filter_match, "Regular Exp");
}


void read_raw_events(GtkWidget * audit_objective_window, gchar * events)
{
	GtkWidget *openfile_radio, *modify_radio, *execute_radio,
	    *remove_radio;
	GtkWidget *openfile_read_radio, *logon_logoff_radio,
	    *open_socket_radio;
	GtkWidget *accept_socket_radio, *event_list_combo;
	G_CONST_RETURN gchar *selected_value;

	openfile_radio =
	    lookup_widget(audit_objective_window, "openfile_radio");
	remove_radio =
	    lookup_widget(audit_objective_window, "remove_radio");
	modify_radio =
	    lookup_widget(audit_objective_window, "modify_radio");
	execute_radio =
	    lookup_widget(audit_objective_window, "execute_radio");
	openfile_read_radio =
	    lookup_widget(audit_objective_window, "openfile_read_radio");
	logon_logoff_radio =
	    lookup_widget(audit_objective_window, "logon_logoff_radio");
	open_socket_radio =
	    lookup_widget(audit_objective_window, "open_socket_radio");
	accept_socket_radio =
	    lookup_widget(audit_objective_window, "accept_socket_radio");
	event_list_combo =
	    lookup_widget(audit_objective_window, "event_list_combo");

	if (gtk_toggle_button_get_active
	    (GTK_TOGGLE_BUTTON(openfile_radio)))
		strcpy(events,
		       "Read, write or create a file or directory");
	else if (gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON(modify_radio)))
		strcpy(events,
		       "Modify system, file or directory attributes");
	else if (gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON(execute_radio)))
		strcpy(events, "Start or stop a program execution");
	else if (gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON(openfile_read_radio)))
		strcpy(events, "Open a file for reading only");
	else if (gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON(logon_logoff_radio)))
		strcpy(events, "User logon or logoff");
	else if (gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON(open_socket_radio)))
		strcpy(events, "Establish an outgoing network connection");
	else if (gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON(accept_socket_radio))) {
		selected_value =
		    gtk_entry_get_text(GTK_ENTRY
				       (GTK_COMBO(event_list_combo)->
					entry));
		strcpy(events, selected_value);
	} else
		strcpy(events, "Change user or group identity");
}


void read_user_match_exp(GtkWidget * obj_window, gchar * user_exp)
{
	GtkWidget *users_entry;
	G_CONST_RETURN gchar *temp;

	users_entry = lookup_widget(obj_window, "users_entry");

	temp = gtk_entry_get_text(GTK_ENTRY(users_entry));
	// ENSURE ONLY 100 BYTES ARE COPIED, EVEN THOUGH THE GUI 
	// WILL ONLY ALLOW 95 BYTES FOR THIS TEXT ENTRY WIDGET
	strncpy(user_exp, temp, 100);
}


void read_filter_match_exp(GtkWidget * obj_window, gchar * filter_exp)
{
	GtkWidget *filter_entry;
	G_CONST_RETURN gchar *temp;

	filter_entry = lookup_widget(obj_window, "exp_entry");

	temp = gtk_entry_get_text(GTK_ENTRY(filter_entry));
	// ENSURE ONLY 100 BYTES ARE COPIED, EVEN THOUGH THE GUI 
	// WILL ONLY ALLOW 95 BYTES FOR THIS TEXT ENTRY WIDGET
	strncpy(filter_exp, temp, 100);
}
