/*
 * Snare for Text Files version 1.3
 *
 * Copyright 2000-2005 InterSect Alliance Pty Ltd
 * http://www.intersectalliance.com/
 *
 * Available under the terms of the GNU Public Licence.
 * - See www.gnu.org
 *
 */
 
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <unistd.h>
#include <syslog.h>
#include <string.h>	// memset()
#include <time.h>	// select()

#define BUFFER_SIZE 8192

#define TYPE_SNARE 1
#define TYPE_SYSLOG 2

void usage(char *);
char * syslogdate(void);

int main(int argc, char *argv[])
{
	int sd, rc, i;
	struct sockaddr_in cliAddr, remoteServAddr;
	struct hostent *h;
	char InputBuffer[BUFFER_SIZE];
	char OutputBuffer[BUFFER_SIZE];
	char HOSTNAME[512];
	int  DestType=TYPE_SNARE;
	char DestString[512];
	char syslogdest[512]="";
	int syslognum=13;	// Default to something sane.
	int argcounter=0;
	int DestPort = 6161;

	/* check command line args */
	if(argc<3) {
		usage(argv[0]);
		return(1);
	}

	argcounter=1;
	
	// Has the user included a 'syslog' flag?
	if(strcmp(argv[1],"-s")==0) {
		if(argc<5) {
			usage(argv[0]);
			return;
		}

		strncpy(syslogdest,argv[2],sizeof(syslogdest));
		DestType=TYPE_SYSLOG;
		DestPort=514;
		syslognum=GetSyslogNum(syslogdest);
		if(!syslognum) {
			syslognum=13;
			fprintf(stderr,"%s is not a valid syslog destination. Defaulting to 13\n");
		}
		argcounter+=2;
	}


	// Get server IP address
	h = gethostbyname(argv[argcounter]);
	if(h==NULL) {
		printf("%s: unknown host '%s' \n", argv[0], argv[argcounter]);
		return(1);
	}
	argcounter++;

	strncpy(DestString,argv[argcounter],sizeof(DestString));

	// Get client name
	if(gethostname(HOSTNAME,sizeof(HOSTNAME)) == -1) {
		printf("%s: Cannot determine local hostname! Exiting.");
		return(1);
	}

	printf("%s: sending data to '%s' (IP: %s) \n", argv[0], h->h_name,
		inet_ntoa(*(struct in_addr *)h->h_addr_list[0]));

	remoteServAddr.sin_family = h->h_addrtype;
	memcpy((char *) &remoteServAddr.sin_addr.s_addr, 
		h->h_addr_list[0], h->h_length);
	remoteServAddr.sin_port = htons(DestPort);

	/* socket creation */
	sd = socket(AF_INET,SOCK_DGRAM,0);
	if(sd<0) {
		printf("%s: cannot open socket \n",argv[0]);
		return(1);
	}
	
	/* bind any port */
	cliAddr.sin_family = AF_INET;
	cliAddr.sin_addr.s_addr = htonl(INADDR_ANY);
	cliAddr.sin_port = htons(0);
	
	rc = bind(sd, (struct sockaddr *) &cliAddr, sizeof(cliAddr));
	if(rc<0) {
		printf("%s: cannot bind port\n", argv[0]);
		return(1);
	}

	while(fgets(InputBuffer,sizeof(InputBuffer),stdin)) {
		if(InputBuffer[strlen(InputBuffer)-1] == '\n') {
			InputBuffer[strlen(InputBuffer)-1] = '\0';
		}
		if(DestType == TYPE_SYSLOG) {

			snprintf(OutputBuffer,sizeof(OutputBuffer),
			 "<%d>%s %s %s	%s",syslognum,syslogdate(),HOSTNAME,DestString,InputBuffer);
		} else {
			snprintf(OutputBuffer,sizeof(OutputBuffer),
			 "%s	%s	%s	%s", HOSTNAME,DestString,"0",InputBuffer);
		}

		rc = sendto(sd, OutputBuffer, strlen(OutputBuffer)+1, 0, 
			(struct sockaddr *) &remoteServAddr, 
			sizeof(remoteServAddr));

		if(rc<0) {
			printf("%s: cannot send data %d \n",argv[0],i-1);
			close(sd);
			return(1);
		}
	}
	
	return 1;

}

void usage(char * exe) {
	if(!exe) { return; }
	printf("usage : tail --follow=name <file> | %s [-s syslog.dest] <dest-server> <logtype>\n", exe);
	printf("   eg : tail --follow=name /var/log/my.log | %s 10.0.0.1 ApacheLog\n", exe);
	printf("   eg : tail --follow=name /var/log/my.log | %s -s local1.info 10.0.0.1 ApacheLog\n", exe);
}

int GetSyslogNum(char * destination)
{
	char strfacility[128]="";
	char strpriority[128]="";
	char *pos;
	int size;
	int facility;
	int priority;

	if(!destination) {
		return(0);
	}

	pos=strstr(destination,".");
	if(!pos) {
		return(0);
	}

	size=pos-destination;
	if(size > sizeof(strfacility)) {
		size=sizeof(strfacility);
	}
	strncpy(strfacility,destination,size);
	strfacility[size]='\0';
	strncpy(strpriority,pos+1,sizeof(strpriority));

	if (strncmp (strfacility, "kern", 1) == 0) {
		facility = LOG_KERN;
	} else if (strncmp (strfacility, "user", 2) == 0) {
		facility = LOG_USER;
	} else if (strncmp (strfacility, "mail", 1) == 0) {
		facility = LOG_MAIL;
	} else if (strncmp (strfacility, "daemon", 1) == 0) {
		facility = LOG_DAEMON;
	} else if (strncmp (strfacility, "auth", 1) == 0) {
		facility = LOG_AUTH;
	} else if (strncmp (strfacility, "syslog", 1) == 0) {
		facility = LOG_SYSLOG;
	} else if (strncmp (strfacility, "lpr", 2) == 0) {
		facility = LOG_LPR;
	} else if (strncmp (strfacility, "news", 1) == 0) {
		facility = LOG_NEWS;
	} else if (strncmp (strfacility, "uucp", 2) == 0) {
		facility = LOG_UUCP;
	} else if (strncmp (strfacility, "cron", 1) == 0) {
		facility = LOG_CRON;
	} else if (strncmp (strfacility, "local0", 6) == 0) {
		facility = LOG_LOCAL0;
	} else if (strncmp (strfacility, "local1", 6) == 0) {
		facility = LOG_LOCAL1;
	} else if (strncmp (strfacility, "local2", 6) == 0) {
		facility = LOG_LOCAL2;
	} else if (strncmp (strfacility, "local3", 6) == 0) {
		facility = LOG_LOCAL3;
	} else if (strncmp (strfacility, "local4", 6) == 0) {
		facility = LOG_LOCAL4;
	} else if (strncmp (strfacility, "local5", 6) == 0) {
		facility = LOG_LOCAL5;
	} else if (strncmp (strfacility, "local6", 6) == 0) {
		facility = LOG_LOCAL6;
	} else if (strncmp (strfacility, "local7", 6) == 0) {
		facility = LOG_LOCAL7;
	} else {
		return(0);
	}

	if(strncmp(strpriority,"emergency",2) == 0) {
		priority=LOG_EMERG;
	} else if(strncmp(strpriority,"alert",1) == 0) {
		priority=LOG_ALERT;
	} else if(strncmp(strpriority,"critical",1) == 0) {
		priority=LOG_CRIT;
	} else if(strncmp(strpriority,"error",2) == 0) {
		priority=LOG_ERR;
	} else if(strncmp(strpriority,"warning",1) == 0) {
		priority=LOG_WARNING;
	} else if(strncmp(strpriority,"notice",1) == 0) {
		priority=LOG_NOTICE;
	} else if(strncmp(strpriority,"information",1) == 0) {
		priority=LOG_INFO;
	} else if(strncmp(strpriority,"debug",1) == 0) {
		priority=LOG_DEBUG;
	} else {
		return(0);
	}
	// return(LOG_MAKEPRI(facility,priority));
	return((priority & LOG_PRIMASK) | (facility & LOG_FACMASK));
}

char * syslogdate()
{
	static char sdate[16];
	struct tm *cdate;
	time_t currenttime;

        char Month[4];
        char Date[3];
        char Hour[3];
        char Min[3];
        char Sec[3];

	time(&currenttime);
	cdate=localtime(&currenttime);

        switch (cdate->tm_mon) {
                case 0: strcpy(Month,"Jan"); break;
                case 1: strcpy(Month,"Feb"); break;
                case 2: strcpy(Month,"Mar"); break;
                case 3: strcpy(Month,"Apr"); break;
                case 4: strcpy(Month,"May"); break;
                case 5: strcpy(Month,"Jun"); break;
                case 6: strcpy(Month,"Jul"); break;
                case 7: strcpy(Month,"Aug"); break;
                case 8: strcpy(Month,"Sep"); break;
                case 9: strcpy(Month,"Oct"); break;
                case 10: strcpy(Month,"Nov"); break;
                default: strcpy(Month,"Dec"); break;
        }

        if(cdate->tm_mday<10) {
                snprintf(Date,3," %d\0",cdate->tm_mday);
        } else {
                snprintf(Date,3,"%d\0",cdate->tm_mday);
        }

        if(cdate->tm_hour<10) {
                snprintf(Hour,3,"0%d\0",cdate->tm_hour);
        } else {
                snprintf(Hour,3,"%d\0",cdate->tm_hour);
        }

        if(cdate->tm_min<10) {
                snprintf(Min,3,"0%d\0",cdate->tm_min);
        } else {
                snprintf(Min,3,"%d\0",cdate->tm_min);
        }

        if(cdate->tm_sec<10) {
                snprintf(Sec,3,"0%d\0",cdate->tm_sec);
        } else {
                snprintf(Sec,3,"%d\0",cdate->tm_sec);
        }

        snprintf(sdate,16,"%s %s %s:%s:%s\0",Month,Date,Hour,Min,Sec);

	return(sdate);
}
