#!/bin/sh
########################################################################
#    
#    (c) 2006 Intersect Alliance Pty Ltd
# 
#   This script will automate the installation of snareapache for UNIX.
#   
#   Version 1.1
#    
#    Usage: ./install.sh
#
########################################################################

########################################################################
#   Check that the necessary files are contained within the local
#   directory. 
########################################################################

file_check()
{

     if [ ! -f /usr/bin/epilog ]
     then
        echo "Cannot find Epilog binary, please install Epilog before installing SnareApache."
	echo "Terminating script."
        exit 1
     fi

     if [ ! -f snareapache.conf.basic ]
     then
        echo "The new basic configuration file is missing. Terminating script."
        exit 1
     fi

     if [ ! -f snareapache_uninstall.sh ]
     then
        echo "The snare removal script is missing. Terminating script."
        exit 1 
     fi
}

########################################################################
#   Check that the user has an effective userid of 0 (root) 
########################################################################

root_check()
{
     id | grep -c uid=0 > /dev/null
     RETVAL=$?

	if [ $RETVAL -gt 0 ]
	then
           echo "You need to be root to run this script. Terminating script."
           exit 1
        else
           echo "Confirmed that you are logged in as root"
	fi

}

########################################################################
#  Check the OS
########################################################################

check_os()
{
   uname | egrep "(Linux|SunOS)" > /dev/null
   RETVAL=$?

   if [ $RETVAL -gt 0 ]
   then
     echo "This agent is currently designed for Solaris and Linux based operating system only. Terminating script"
     exit 1
   fi 
	
}

########################################################################
#  This is the main loop  
########################################################################

file_check 
root_check
check_os

INSTAL=0
SNAREC=0

if [ -f /etc/snare/epilog/apache.conf ]; then
   SNAREC=1
fi

if [ -f /etc/init.d/snareapached ]; then
	echo "WARNING: It looks as though SnareApache is already installed."
	echo
	echo "Please uninstall SnareApache first before proceeding: /etc/snare/snareapache_uninstall.sh"
	echo
	exit
fi

# Kill off any outstanding pid files.
if [ -f /var/run/snareapache.pid ]; then
	rm -f /var/run/snareapache.pid >/dev/null 2>&1
fi

if [ "$SNAREC" -eq "1" ]; then
	while [ "$INSTAL" -ne "1" ] && [ "$INSTAL" -ne "2" ] && [ "$INSTAL" -ne "3" ] && [ "$INSTAL" -ne "4" ]
	do
	  echo 
	  echo "Enter [1] to install a basic starting configuration"
	  echo "Enter [2] to preserve the EXISTING snare configuration file"
	  echo "Enter anything else to terminate the script"
	  echo -n "Selection: "
	    read INSTAL
	    case $INSTAL in
	       1) echo "Installing basic configuration files"; INSTALL_TYPE=1 ;;
	       2) echo "Preserving existing SNARE configuration"; INSTALL_TYPE=2;;
	       *) echo "Script terminating at user request"; exit 1 ;;
	    esac 
	done
else
   INSTALL_TYPE=1
fi
 

########################################################################
#  This provides the final warning before the software is loaded onto
#  the system. In case of mistakes, it allows the user to escape before 
#  the software is loaded.   
########################################################################

echo 
echo "*************************************************"
echo 
echo "You are about to install SnareApache on this host."
echo "Your selections are as follows:"
if [ $INSTALL_TYPE -eq 1 ]; then
  echo "Basic Installation"
else
  echo "Preserving existing configuration file."
fi



########################################################################
#  This will copy the common files to the /etc directory.  
########################################################################

if [ $INSTALL_TYPE -eq 1 ] || [ $INSTALL_TYPE -eq 2 ]; then

   echo
   echo "Installing common files..........."

   # link to epilog
   ln -sf /usr/bin/epilog /usr/bin/snareapache

   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to create the snareapache program to /usr/bin. Terminating script"
     exit 1
   fi

   chown root:root /usr/bin/snareapache
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to change owner for file to /usr/bin/snareapache. Terminating script"
     exit 1
   fi
   chmod  550 /usr/bin/snareapache
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to change the permissions for file to /usr/bin/snareapache. Terminating script"
     exit 1
   fi

   cp ./snareapache_start.sh  /etc/init.d/snareapached
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the startup script: /etc/init.d/snareapached. Terminating script"
     exit 1
   fi

   cp snareapache_uninstall.sh /etc/snare/snareapache_uninstall.sh
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the snare uninstall.sh script to /etc/snare. Terminating script"
     exit 1
   fi

   uname | grep Linux > /dev/null
   RETVAL=$?
   if [ $RETVAL -gt 0 ]; then
	   ln /etc/init.d/snareapached /etc/rc0.d/K33snareapached
	   ln /etc/init.d/snareapached /etc/rc1.d/K33snareapached
	   ln /etc/init.d/snareapached /etc/rc2.d/S99zsnareapached
   else
	   ln -s /etc/init.d/snareapached /etc/rc0.d/K33snareapached
	   ln -s /etc/init.d/snareapached /etc/rc1.d/K33snareapached
	   ln -s /etc/init.d/snareapached /etc/rc2.d/S99zsnareapached
	   ln -s /etc/init.d/snareapached /etc/rc3.d/S99zsnareapached
	   ln -s /etc/init.d/snareapached /etc/rc4.d/S99zsnareapached
	   ln -s /etc/init.d/snareapached /etc/rc5.d/S99zsnareapached
	   ln -s /etc/init.d/snareapached /etc/rc6.d/K33snareapached
   fi
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to create etc/rc*.d files. Terminating script"
     exit 1
   fi

   echo
   echo "Successfully installed the common files"
   echo
fi

	
########################################################################
#  This will copy the basic files to /etc/snare/epilog
#  It will also change the owner and permissions for these files.
########################################################################

if [ $INSTALL_TYPE -eq 1 ]
then
   echo
   echo "Installing basic configuration files..........."

   mkdir -p /etc/snare/epilog
   cp ./snareapache.conf.basic /etc/snare/epilog/apache.conf
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the configuration file to /etc/snare/epilog. Terminating script"
     exit 1 
   fi
   chown root:root /etc/snare/epilog/apache.conf
   chmod 600 /etc/snare/epilog/apache.conf

fi

echo
echo "Successfully installed the necessary files. Activating monitoring..."
echo 

/etc/init.d/snareapached start
sleep 2

PID=`ps -ef -u 0|fgrep snareapache|egrep -v fgrep|awk '{print $2}'`
if [ -z "$PID" ] ;  then
        echo "SnareApache not running. Please check installation parameters."
        exit 1;
fi

echo "Done."
echo
if [ $INSTALL_TYPE -ne 2 ]; then
        echo "SnareApache will also be activated after a reboot via the"
        echo "init.d/snareapached startup script."
	echo
	echo "Please connect to the local machine using your web browser"
	echo "using the following URL: http://"`hostname`":6162/"
	echo "and a userid and password of 'snare'"
	echo "Once connected, please CHANGE THE DEFAULT PASSWORD, configure"
	echo "any additonal audit objectives you require, and restart"
	echo "the audit server".
	echo ""
else
	echo "SnareApache has been upgraded. Note that Snare now supports"
	echo "passwords to be in MD5 hash format."
	echo ""
	echo "Recommend that you re-set the password used for snare"
	echo "remote access in order to take advantage of the new"
	echo "password scheme."
fi

exit 0
