#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "webserver.h"
#include "WebPages.h"

#define MAX_HTTPBUFFER 8192

// Socket for our pseudo-httpd server
int http_listen_socket;
int http_message_socket;

// Signals
int caught_pipe=0;                /* variable that lets us know when a SIGPIPE has been received */
int caught_kill=0;                /* variable that lets us know when a SIGKILL has been received */

// unsigned char alphabet[65] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
unsigned char alphabet[65];

// NOTE: This password sits in RAM.
// A user with appropriate access could pull it out.
// .. they could also grab it from the registry.
// Note: Despite the fact that we set the string, this does NOT represent a default password.
char SnarePass[256];
char SnareIP[16];

int InitWebServer(unsigned short port,char *ip, char *password)
{
	struct sockaddr_in local;
	int sockopt=1;
    
	strncpy(alphabet,"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",65);    
    strncpy(SnarePass,"",255);    
    strncpy(SnareIP,"",15);    
    http_listen_socket=NULL;    
    http_message_socket=NULL;
	
	// This is already done by the main routine.
/*	if(!setsignals()) {
		fprintf(stderr,"Cannot set important signals - exiting web server\n");
		return(-1);
	}*/
	
	if(password) {
		strncpy(SnarePass,password,256);
	}
	
	if(ip) {
		if(strlen(ip)) {
			strncpy(SnareIP,ip,256);
		} else {
			strcpy(SnareIP,"");
		}
	} else {
		strcpy(SnareIP,"");
	}
		
	local.sin_family = AF_INET;
	local.sin_addr.s_addr = INADDR_ANY; 

	local.sin_port = htons(port);

	http_listen_socket = socket(AF_INET, SOCK_STREAM,0); // TCP socket
	setsockopt(http_listen_socket,SOL_SOCKET,SO_REUSEADDR,&sockopt,sizeof(sockopt));
	
	if (http_listen_socket == -1){
		perror("socket() failed");
		return -1;
	}

	if (bind(http_listen_socket,(struct sockaddr*)&local,sizeof(local) )) {
		perror("bind() failed");
		return -1;
	}

	if (listen(http_listen_socket,5)) {
		perror("listen() failed");
		return -1;
	}
	
	return(1);
}

int CloseWebServer()
{
	close(http_listen_socket);
	return(1);
}

int HandleConnect()
{	
	int retval;
	// 8k buffer for input and output. Suggest we may need more for output.
	char HTTPBuffer[MAX_HTTPBUFFER];
	char HTTPOutputBuffer[MAX_HTTPBUFFER];
	char *pos;
	int size=0;

	retval = recv(http_message_socket,HTTPBuffer,sizeof (HTTPBuffer),0 );
	// NOTE: Should probably do something about requests that are bigger than
	// HTTPBuffer also..

	if (retval == -1) {
		// perror("recv() failed");
		close(http_message_socket);
		return(1);
	}
	if (retval == 0) {
		close(http_message_socket);
		return(1);
	}

	HTTPBuffer[retval]='\0';

	// Hunt down the authentication string
	// Dont ask for authentication if the password is blank.
	pos=strstr(HTTPBuffer,"Authorization: Basic ");
	if(strlen(SnarePass) && !pos) {
		RequestAuth(HTTPOutputBuffer,MAX_HTTPBUFFER);
	} else if(strlen(SnarePass) && !MatchAuth(pos + strlen("Authorization: Basic "))) {
		RequestAuth(HTTPOutputBuffer,MAX_HTTPBUFFER);
	} else {
		// Don't care about anything after the GET
		pos=strstr(HTTPBuffer,"\n");
		if(pos) {
			*pos='\0';
		}
		pos=strstr(HTTPBuffer,"\r");
		if(pos) {
			*pos='\0';
		}

		// Get rid of the "GET "
		pos=strstr(HTTPBuffer," ");
		if(pos) {
			strncpy(HTTPBuffer,pos+1,MAX_HTTPBUFFER);
		}
			
		// and the HTTP/1.x
		pos=strstr(HTTPBuffer," ");
		if(pos) {
			*pos='\0';
		}

		decodeurl(HTTPBuffer);

		// size=HandleWebPages(HTTPBuffer,HTTPOutputBuffer,MAX_HTTPBUFFER);
		size=HandleWebPages(HTTPBuffer,HTTPOutputBuffer,MAX_HTTPBUFFER,http_listen_socket,http_message_socket);
	}

	if(size == 0 && HTTPOutputBuffer) {
		size=strlen(HTTPOutputBuffer);
	}

	retval = send(http_message_socket,HTTPOutputBuffer,size,0);

	if (retval == -1) {
		perror("send() failed");
	}

	close(http_message_socket);
	
	return(1);
}

int StartThread()
{
	int ret=0;

	while(!caught_kill) {
		ret=ListenThread();
		
		if(!ret)
			break;
	}
	CloseWebServer();

	if(caught_kill)
		return(-1);
	
	if(ret) {
		return(1);
	}
	
	return(0);
}


int ListenThread()
{
	struct sockaddr_in from;
	int fromlen;
	int invalidrequest=1;
	char ip_address[16];

	fromlen=sizeof(from);

	while(invalidrequest) {
		
		http_message_socket = accept(http_listen_socket,(struct sockaddr*)&from, &fromlen);
		if (http_message_socket == -1) {
			perror("accept() error - The target TCP port looks to be currently in use");
			return(0);
				
		}
		// printf("DEBUG: accepted connection from %s, port %d\n", 
		//	inet_ntoa(from.sin_addr),
		//	htons(from.sin_port)) ;

		strncpy(ip_address,inet_ntoa(from.sin_addr),16);

		if(AuthorisedSource(ip_address)) {
			invalidrequest=0;
		} else {
			invalidrequest=1;
			send(http_message_socket,"<HTML><BODY><CENTER>Authentication failed</CENTER></BODY></HTML>\n\0",66,0);
			close(http_message_socket);
		}
	}

	HandleConnect();
	return(1);
	
}

int AuthorisedSource(char *address)
{
	if(!address) return(0);
	if(!strlen(address)) return(1);
	if(!strlen(SnareIP)) return(1);
	if(!strncmp(address,SnareIP,16)) {
		return(1);
	}
	return(0);
}

void decodeurl(char *pEncoded)
{
	char *pDecoded;

	pDecoded=pEncoded;
	while (*pDecoded) {
		if (*pDecoded=='+') *pDecoded=' ';
		pDecoded++;
	};
	pDecoded=pEncoded;
	while (*pEncoded) {
		if (*pEncoded=='%') {
			pEncoded++;
			if(pEncoded[0]) {
				if(pEncoded[1]) {
					if (isxdigit(pEncoded[0])&&isxdigit(pEncoded[1])) {
						// *pDecoded++=(char)hex2int((char *)pEncoded);
						// Special InterSect Alliance - escape ampersands and slashes.
						// Note: hex characters are 3 bytes, we are only substituting 2, so no
						// problems with buffer overflows.
						*pDecoded=(char)hex2int((char *)pEncoded);
						if(*pDecoded=='&') {
							*pDecoded++='\\';
							*pDecoded='&';
						} else if(*pDecoded=='\\') {
							*pDecoded++='\\';
							*pDecoded='\\';
						} else if(*pDecoded=='=') {
							*pDecoded++='\\';
							*pDecoded='=';
						}
						pDecoded++;

						pEncoded+=2;
					}
				} else {
					break;
				}
			} else {
				break;
			}
		} else {
			*pDecoded++=*pEncoded++;
		}
	}
	*pDecoded='\0';
}

// Find ampersand-delimited strings (but ignore escaped ampersands).
char * GetNextArgument(char *source,char *destvar,int varlength,char *destval,int vallength)
{
	char prevchar='\0';
	int destlen=0;

	if(!source || !destvar || !destval) {
		return((char *)NULL);
	}

	if(!*source) {
		return((char *)NULL);
	}

	*destvar='\0';
	*destval='\0';

	// length = maximum size of dest
	while(*source && !(*source == '&' && prevchar != '\\') && !(*source == '=' && prevchar != '\\') && destlen<varlength) {

		if(*source!='\\' || (*source == '\\' && prevchar == '\\')) {
			*destvar=*source;
			destvar++;
			destlen++;
		}

		prevchar=*source;
		source++;
	}
	*destvar='\0';

	destlen=0;

	if(*source == '=') {
		// We have a value. Excellent.
		*source++;
	
		while(*source && !(*source == '&' && prevchar != '\\') && destlen<vallength) {
			if(*source!='\\' || (*source == '\\' && prevchar == '\\')) {
				*destval=*source;
				destval++;
				destlen++;
			}

			prevchar=*source;
			source++;
		}
		*destval='\0';
	}

	// Return our position in the new string, or null for end of string.
	if(*source) {
		*source++;
	}

	return(source);
}


int hex2int(char *pChars)
{
	int Hi;
	int Lo;
	int Result;

	Hi=pChars[0];
	if ('0'<=Hi&&Hi<='9') {
		Hi-='0';
	} else if ('a'<=Hi&&Hi<='f') {
		Hi-=('a'-10);
	} else if ('A'<=Hi&&Hi<='F') {
		Hi-=('A'-10);
	}
	Lo = pChars[1];
	if ('0'<=Lo&&Lo<='9') {
		Lo-='0';
	} else if ('a'<=Lo&&Lo<='f') {
		Lo-=('a'-10);
	} else if ('A'<=Lo&&Lo<='F') {
		Lo-=('A'-10);
	}
	Result=Lo+(16*Hi);
	return (Result);
}

void RequestAuth(char *HTTPOutputBuffer,int size)
{
	strncpy(HTTPOutputBuffer,"HTTP/1.0 401 Unauthorized\n" \
		"Connection: close\n" \
		"Content-Type: text/html\n" \
		"Server: SNARE\n" \
		"WWW-Authenticate: Basic realm=\"SNARE\"\n",size);
}

int MatchAuth(char *AuthStart)
{
	char AuthString[256];
	char *pos;
	int length=0;

	// Hunt down end of line
	pos=strstr(AuthStart,"\r");
	if(!pos) {
		pos=strstr(AuthStart,"\n");
	}
	if(!pos) {
		pos=AuthStart+strlen(AuthStart);
	}

	if(!pos) return(0);

	length=pos-AuthStart;
	if(length<1) return(0);
	
	strncpy(AuthString,AuthStart,length);
	AuthString[length]='\0';

	length=base64decode(AuthString,AuthString,256);
	AuthString[length]='\0';

	pos=strstr(AuthString,":");

	if(!pos) return(0);

	*pos='\0';
	pos++;


	if(strcmp(AuthString,"snare") && strcmp(AuthString,"Snare") && strcmp(AuthString,"SNARE")) {
		// Username does not match
		return(0);
	}

	if(!strcmp(pos,SnarePass)) {
		// Password matches
		return(1);
	}

	return(0);

}

int base64decode(char *dest, char *src, int length)
{
    static char inalphabet[256], decoder[256];
    int count;
	int bits;
	int c;
	int character_count;
    int rpos;
    int wpos = 0;
	
    // Build decode table
    for (count = (sizeof alphabet) - 1; count >= 0; count--) {
		inalphabet[alphabet[count]] = 1;
		decoder[alphabet[count]] = count;
	}
	
    character_count = 0;
    bits = 0;
    for(rpos = 0; rpos < length; rpos++) {
		c = src[rpos];
		
		if (c == '=') {
			break;
		}
		
		if (c > 255 || ! inalphabet[c]) {
			continue;
		}
		
		bits += decoder[c];
		character_count++;
		if (character_count < 4) {
			bits <<= 6;
		} else {
			dest[wpos++] = bits >> 16;
			dest[wpos++] = (bits >> 8) & 0xff;
			dest[wpos++] = bits & 0xff;
			bits = 0;
			character_count = 0;
		}

	}
	
    // c == '='
    if(character_count == 1) {
		// error: at least two bits are missing.
		return(wpos);
	} else if(character_count == 2) {
		dest[wpos++] = bits >> 10;
	} else if(character_count == 3) {
		dest[wpos++] = bits >> 16;
		dest[wpos++] = (bits >> 8) & 0xff;
	}
    return wpos;
}
