#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <crypt.h>
#include <ctype.h>

#include <signal.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <strings.h>

#include <errno.h>

#include "webserver.h"
#include "WebPages.h"

#define MAX_HTTPBUFFER 8192

// Socket for our pseudo-httpd server
int http_listen_socket;
int http_message_socket;

// Signals
int caught_pipe = 0;		/* variable that lets us know when a SIGPIPE has been received */
int caught_kill = 0;		/* variable that lets us know when a SIGKILL has been received */


// NOTE: This password sits in RAM.
// A user with appropriate access could pull it out.
char SnarePass[256];
char SnareIP[16];

void webkill(sig) {
	caught_kill++;
	return;
}

int InitWebServer(unsigned short port, char *ip, char *password)
{
	struct sockaddr_in local;
	int sockopt = 1;

	strncpy(SnarePass, "", 255);
	strncpy(SnareIP, "", 15);
	http_listen_socket = NULL;
	http_message_socket = NULL;

	signal(SIGPIPE,SIG_IGN);
	// signal(SIGTERM,webkill);

	if (password) {
		strncpy(SnarePass, password, 256);
	}

	if (ip) {
		if (strlen(ip)) {
			strncpy(SnareIP, ip, 256);
		} else {
			strcpy(SnareIP, "");
		}
	} else {
		strcpy(SnareIP, "");
	}

	local.sin_family = AF_INET;
	local.sin_addr.s_addr = INADDR_ANY;

	local.sin_port = htons(port);

	http_listen_socket = socket(AF_INET, SOCK_STREAM, 0);	// TCP socket
	setsockopt(http_listen_socket, SOL_SOCKET, SO_REUSEADDR, &sockopt,
		   sizeof(sockopt));

	if (http_listen_socket == -1) {
		perror("socket() failed");
		return -1;
	}

	if (bind
	    (http_listen_socket, (struct sockaddr *) &local,
	     sizeof(local))) {
		perror("bind() failed");
		return -1;
	}

	if (listen(http_listen_socket, 5)) {
		perror("listen() failed");
		return -1;
	}

	return (1);
}

int CloseWebServer()
{
	if(http_message_socket > 0) {
		shutdown(http_message_socket,SHUT_RDWR);
		close(http_message_socket);
		http_message_socket=-1;
	}

	if(http_listen_socket > 0) {
		shutdown(http_listen_socket,SHUT_RDWR);
		close(http_listen_socket);
		http_listen_socket=-1;
	}
	return (1);
}

int HandleConnect()
{
	int retval;
	// 8k buffer for input and output. Suggest we may need more for output.
	char HTTPBuffer[MAX_HTTPBUFFER];
	char HTTPOutputBuffer[MAX_HTTPBUFFER];
	char *pos;
	int size = 0;
	int header = 1;

	retval =
	    recv(http_message_socket, HTTPBuffer, sizeof(HTTPBuffer), 0);
	// NOTE: Should probably do something about requests that are bigger than
	// HTTPBuffer also..

	if (retval == -1) {
		// perror("recv() failed");
		close(http_message_socket);
		return (1);
	}
	if (retval == 0) {
		close(http_message_socket);
		return (1);
	}

	HTTPBuffer[retval] = '\0';

	// Hunt down the authentication string
	// Dont ask for authentication if the password is blank.
	pos = strstr(HTTPBuffer, "Authorization: Basic ");
	if (strlen(SnarePass) && !pos) {
		RequestAuth(HTTPOutputBuffer, MAX_HTTPBUFFER);
		header = 0;
	} else if (strlen(SnarePass)
		   && !MatchAuth(pos + strlen("Authorization: Basic "))) {
		RequestAuth(HTTPOutputBuffer, MAX_HTTPBUFFER);
		header = 0;
	} else {
		// Don't care about anything after the GET
		pos = strstr(HTTPBuffer, "\n");
		if (pos) {
			*pos = '\0';
		}
		pos = strstr(HTTPBuffer, "\r");
		if (pos) {
			*pos = '\0';
		}
		// Get rid of the "GET "
		pos = strstr(HTTPBuffer, " ");
		if (pos) {
			strncpy(HTTPBuffer, pos + 1, MAX_HTTPBUFFER);
		}
		// and the HTTP/1.x
		pos = strstr(HTTPBuffer, " ");
		if (pos) {
			*pos = '\0';
		}

		decodeurl(HTTPBuffer);

		size =
		    HandleWebPages(HTTPBuffer, HTTPOutputBuffer,
				   MAX_HTTPBUFFER, http_listen_socket,
				   http_message_socket);
	}

	if (size == -1) {
		size = 0;
	} else if (size == 0 && HTTPOutputBuffer) {
		size = strlen(HTTPOutputBuffer);
	}

	if (size) {
		// Overwrite HTTPBuffer with the header data.
		strncpy(HTTPBuffer, "HTTP/1.0 200 OK\r\n"
			"Server: SNARE/1.0\r\n"
			"MIME-version: 1.0\r\n"
			"Content-type: text/html\r\n\r\n",
			sizeof(HTTPBuffer));

		if (header) {
			retval =
			    send(http_message_socket, HTTPBuffer,
				 strlen(HTTPBuffer), 0);
			if (retval == -1) {
				perror("send() failed");
			}
		}

		retval =
		    send(http_message_socket, HTTPOutputBuffer, size, 0);

		//if (retval == -1) {
		//	perror("send() failed");
		//}
	}

	shutdown(http_message_socket,SHUT_RDWR);
	close(http_message_socket);

	return (1);
}

int StartThread()
{
	int ret = 0;

	while (!caught_kill) {
		ret = ListenThread();

		if (!ret)
			break;
	}
	CloseWebServer();

	if (caught_kill) {
		return (-1);
	}

	if (ret) {
		return (1);
	}

	return (0);
}

int ListenThread()
{
	struct sockaddr_in from;
	int fromlen;
	int invalidrequest = 1;
	char ip_address[16];

	//struct timeval timeout;
	//bzero(&timeout, sizeof(timeout));
	//timeout.tv_sec = 1;

	fromlen = sizeof (from);

	while (invalidrequest) {

		http_message_socket =
		    accept(http_listen_socket, (struct sockaddr *) &from,
			   &fromlen);

		//setsockopt(http_message_socket,SOL_SOCKET,SO_SNDTIMEO,&timeout,sizeof(timeout));

		if(caught_kill) {
			return(0);
		}

		if (http_message_socket == -1) {
			perror
			    ("accept() error - The target TCP port looks to be currently in use");
			return (0);

		}
		// printf("DEBUG: accepted connection from %s, port %d\n", 
		//      inet_ntoa(from.sin_addr),
		//      htons(from.sin_port)) ;

		strncpy(ip_address, inet_ntoa(from.sin_addr), 16);

		if (AuthorisedSource(ip_address)) {
			invalidrequest = 0;
		} else {
			invalidrequest = 1;
			send(http_message_socket,
			     "<HTML><BODY><CENTER>Authentication failed</CENTER></BODY></HTML>\n\0",
			     66, 0);
			close(http_message_socket);
		}
	}

	HandleConnect();
	return (1);

}

int AuthorisedSource(char *address)
{
	if (!address)
		return (0);
	if (!strlen(address))
		return (1);
	if (!strlen(SnareIP))
		return (1);
	if (!strncmp(address, SnareIP, 16)) {
		return (1);
	}
	return (0);
}

void decodeurl(char *pEncoded)
{
	char *pDecoded;

	pDecoded = pEncoded;
	while (*pDecoded) {
		if (*pDecoded == '+')
			*pDecoded = ' ';
		pDecoded++;
	};
	pDecoded = pEncoded;
	while (*pEncoded) {
		if (*pEncoded == '%') {
			pEncoded++;
			if (pEncoded[0]) {
				if (pEncoded[1]) {
					if (isxdigit((int)pEncoded[0])
					    && isxdigit((int)pEncoded[1])) {
						// *pDecoded++=(char)hex2int((char *)pEncoded);
						// Special InterSect Alliance - escape ampersands and slashes.
						// Note: hex characters are 3 bytes, we are only substituting 2, so no
						// problems with buffer overflows.
						*pDecoded =
						    (char) hex2int((char *)
								   pEncoded);
						if (*pDecoded == '&') {
							*pDecoded++ = '\\';
							*pDecoded = '&';
						} else if (*pDecoded ==
							   '\\') {
							*pDecoded++ = '\\';
							*pDecoded = '\\';
						} else if (*pDecoded ==
							   '=') {
							*pDecoded++ = '\\';
							*pDecoded = '=';
						}
						pDecoded++;

						pEncoded += 2;
					}
				} else {
					break;
				}
			} else {
				break;
			}
		} else {
			*pDecoded++ = *pEncoded++;
		}
	}
	*pDecoded = '\0';
}

// Find ampersand-delimited strings (but ignore escaped ampersands).
char *GetNextArgument(char *source, char *destvar, int varlength,
		      char *destval, int vallength)
{
	char prevchar = '\0';
	int destlen = 0;

	if (!source || !destvar || !destval) {
		return ((char *) NULL);
	}

	if (!*source) {
		return ((char *) NULL);
	}

	*destvar = '\0';
	*destval = '\0';

	// length = maximum size of dest
	while (*source && !(*source == '&' && prevchar != '\\')
	       && !(*source == '=' && prevchar != '\\')
	       && destlen < (varlength - 1)) {

		if (*source != '\\'
		    || (*source == '\\' && prevchar == '\\')) {
			*destvar = *source;
			destvar++;
			destlen++;
		}

		prevchar = *source;
		source++;
	}
	*destvar = '\0';

	destlen = 0;

	if (*source == '=') {
		// We have a value. Excellent.
		source++;

		while (*source && !(*source == '&' && prevchar != '\\')
		       && destlen < (vallength-1)) {
			if (*source != '\\'
			    || (*source == '\\' && prevchar == '\\')) {
				*destval = *source;
				destval++;
				destlen++;
			}

			prevchar = *source;
			source++;
		}
		*destval = '\0';
	}
	// Return our position in the new string, or null for end of string.
	if (*source) {
		source++;
	}

	return (source);
}

int hex2int(char *pChars)
{
	int Hi;
	int Lo;
	int Result;

	Hi = pChars[0];
	if ('0' <= Hi && Hi <= '9') {
		Hi -= '0';
	} else if ('a' <= Hi && Hi <= 'f') {
		Hi -= ('a' - 10);
	} else if ('A' <= Hi && Hi <= 'F') {
		Hi -= ('A' - 10);
	}
	Lo = pChars[1];
	if ('0' <= Lo && Lo <= '9') {
		Lo -= '0';
	} else if ('a' <= Lo && Lo <= 'f') {
		Lo -= ('a' - 10);
	} else if ('A' <= Lo && Lo <= 'F') {
		Lo -= ('A' - 10);
	}
	Result = Lo + (16 * Hi);
	return (Result);
}

void RequestAuth(char *HTTPOutputBuffer, int size)
{
	strncpy(HTTPOutputBuffer, "HTTP/1.0 401 Unauthorized\n"
		"Connection: close\r\n"
		"Content-Type: text/html\r\n"
		"Server: SNARE\r\n"
		"WWW-Authenticate: Basic realm=\"SNARE\"\r\n\r\n"
		"<html><body><center>Unauthorised</center></body></html>\r\n", size);
}

int MatchAuth(char *AuthStart)
{
	char AuthString[256]="";
	char AuthString2[256]="";
	char TempAuth[256]="";
	char *pos;
	char *crypttext;
	int length=0;

	// Hunt down end of line
	pos=AuthStart;

	while(isalpha((int)*pos) || (*pos >= '0' && *pos <= '9') || *pos == '+' || *pos == '=') {
		pos++;
	}

	if(!pos) return(0);

	length=pos-AuthStart;
	if(length<1) return(0);

	if(length >= sizeof(AuthString)) {
		length=sizeof(AuthString) - 1;
	}
	strncpy(AuthString,AuthStart,length);
	AuthString[length]='\0';

	length=base64decode(AuthString2,AuthString);

	pos=strstr(AuthString2,":");

	if(!pos) return(0);

	*pos='\0';
	pos++;
	strncpy(TempAuth,pos,sizeof(TempAuth));

	if(strcmp(AuthString2,"snare") && strcmp(AuthString2,"Snare") && strcmp(AuthString2,"SNARE")) {
		// Username does not match
		return(0);
	}

	// Reuse authstring here.
	crypttext=crypt(TempAuth,SALT);
	if(crypttext) {
		strncpy(AuthString2,crypttext,sizeof(AuthString2));
	} else {
		strncpy(AuthString2,"",sizeof(AuthString2));
		// Hmm.. fall back to normal crypt.
		fprintf(stderr,"SNARE Warning: Your version of Solaris does not seem to support BSD MD5 Checksums in crypt.conf\n");
	}

	if(!strcmp(AuthString2,SnarePass)) {
		// Password matches
		return(1);
	}

	// Do we need a fallback here for plaintext passwords?
	// If so, how do we guard against a user just entering the md5
	// checksum as a password?

	// Lets md5 the SnarePass value, and check it against the crypted value.
	crypttext=crypt(SnarePass,SALT);
	if(crypttext) {
		if(!strcmp(AuthString2,crypttext)) {
			// fprintf(stderr,"SNARE Warning: Non-encrypted password used in snare.conf file.\n");
			return(1);
		}
	}

	return(0);
}

int Send(int sock,char *string,int size) {
	int rc=0;
	if(!sock) {
		return(0);
	}
	if(!string || !size) {
		return(0);
	}

	rc=send(sock,string,size,MSG_DONTWAIT);
	return(rc);
}


int base64decode(char *dest, char *src)
{
	char *ascii, *pBase64, *mBase64;
	char TopVal, BottomVal;
	int chars_left, i, padding, count=0;
	
	mBase64 = (char *) malloc(strlen(src) + 1);
	pBase64 = mBase64;
	if (pBase64 == NULL) {
		dest[0] = '\0';	// Returns null if there was a problem
		return(0);
	}
	
	strcpy(pBase64, src);
	ascii = dest;
	
	chars_left = strlen(pBase64);
	while (chars_left > 0) {
		padding = 0;
		for (i = 0; i < 4; i++) {
			if (pBase64[i] == '=') {
				padding++;
			} else if (pBase64[i] == '+') {
				pBase64[i] = 62;
			} else if (pBase64[i] == '/') {
				pBase64[i] = 63;
			} else if (pBase64[i] <= '9') {
				pBase64[i] = pBase64[i] + 52 - '0';
			} else if (pBase64[i] <= 'Z') {
				pBase64[i] = pBase64[i] - 'A';
			} else {
				pBase64[i] = pBase64[i] + 26 - 'a';
			}
		}
		TopVal = pBase64[0] << 2;
		BottomVal = pBase64[1] >> 4;
		ascii[0] = TopVal | BottomVal;
		count++;
		
		if (padding < 2) {
			TopVal = pBase64[1] << 4;
			BottomVal = pBase64[2] >> 2;
			ascii[1] = TopVal | BottomVal;
			count++;
			if (padding < 1) {
				TopVal = pBase64[2] << 6;
				ascii[2] = TopVal | pBase64[3];
				count++;
			} else {
				ascii[2] = '\0';
			}
		} else {
			ascii[1] = '\0';
		}
		
		ascii += 3;
		pBase64 += 4;
		chars_left -= 4;
	}
	*ascii = '\0';
	free(mBase64);
	return(count);
}
