//
// webserver.h
// Copyright (c) 1999-2004 InterSect Alliance Pty Ltd
//

#ifndef _WEBSERVER_H_
#define _WEBSERVER_H_ 1

#define MAX_HTTPBUFFER 8192

#ifdef __linux__
        #define SALT "$1$Snare$"
#else
        // Solaris
        // #define SALT "$md5"
        #define SALT "$1"
#endif

void	decodeurl(char *pEncoded);
int	hex2int(char *pChars);
int	InitWebServer(unsigned short, char *, char *);
int	StartThread();
int	ListenThread();
int	HandleConnect(void);
int	CloseWebServer();
void	RequestAuth(char *HTTPOutputBuffer,int size);
int	MatchAuth(char *AuthStart);
int	AuthorisedSource(char *address);
char *	GetNextArgument(char *source,char *destvar,int varlength,char *destval,int vallength);
int	base64decode(char *dest, char *src);
int	Send(int,char *,int);

#endif // _WEBSERVER_H_ 1
