#ifndef _WEBPAGES_H_
#define _WEBPAGES_H_ 1

#define SIZE_OF_RESTRICTIP               20
#define SIZE_OF_PASSWORD                 256
#define SIZE_OF_EVENTIDMATCH     256
#define SIZE_OF_USERMATCH                256
#define SIZE_OF_GENERALMATCH     512
#define SIZE_OF_EVENTLOG                 35
#define SIZE_OF_CRITICALITY              12
#define SIZE_OF_AN_OBJECTIVE     1056
#define SIZE_OF_CLIENTNAME               100
#define SIZE_OF_DESTINATION              100
#define SIZE_OF_USER_MATCH_TYPE  10
#define SIZE_OF_GENERAL_MATCH_TYPE  10
#define WEB_READ_CONFIG_ERROR_CODE              510000
#define WEB_READ_NETWORK_ERROR_CODE             530000
#define WEB_READ_REMOTE_ERROR_CODE              580000
#define WEB_READ_OBJECTIVE_ERROR_CODE   610000
#define WEB_WRITE_CONFIG_ERROR_CODE             660000
#define WEB_WRITE_NETWORK_ERROR_CODE    720000
#define WEB_WRITE_REMOTE_ERROR_CODE             770000
#define WEB_WRITE_OBJECTIVE_ERROR_CODE  850000
#define WEB_RESTART_SERVICE_ERROR_CODE  890000

#define CRITICAL_TOKEN "Critical"
#define PRIORITY_TOKEN "Priority"
#define WARNING_TOKEN "Warning"
#define INFORMATION_TOKEN "Information"
#define CLEAR_TOKEN "Clear"

#define SUCCESS_TOKEN "Success"
#define FAILURE_TOKEN "Failure"
#define ALL_TOKEN ".*"

#define LOGON_LOGOFF_EVENTS "login,logout,telnet,rlogin,su,rexecd,passwd,rexd,ftpd,admin_authenticate"
#define FILE_READ_EVENTS "open_r,readlink"
#define FILE_WRITE_EVENTS "open_rc,open_rt,open_rtc,open_w,open_wc,open_wt,open_wtc,open_rw,open_rwc,open_rwt,open_rwtc,creat,mkdir,mknod,xmknod,link,symlink,rmdir,unlink,rename,truncate,ftruncate"
#define FILE_REMOVE_EVENTS "rmdir,unlink"
#define FILE_ATTRIB_EVENTS "chmod,fchmod,chown,fchown,mctl,fcntl,lchown,aclset,faclset"
#define PROCESS_EVENTS "exec,execve"
#define USER_EVENTS "setgroups,setpgrp,setuid,setgid,seteuid,setegid,setauid,setreuid,setregid,osetuid,osetpgrp"
#define SOCKET_EVENTS "connect,shutdown,setsockopt"


#define LOGONOFF_TOKEN "Logon_Logoff"
#define FILE_READ_TOKEN "File_Read"
#define FILE_WRITE_TOKEN "File_Write"
#define FILE_ATTRIB_TOKEN "File_Attrib"
#define FILE_REMOVE_TOKEN "File_Remove"
#define PROCESS_TOKEN "Process_Events"
#define USER_TOKEN "User_Events"
#define SOCKET_TOKEN "Socket_Events"

struct Reg_Host {
	char str_NetworkDestination[SIZE_OF_DESTINATION];
	int dw_DestPort;
	int dw_Protocol;
	struct Reg_Host *next;
};

// The following structure has been defined to cater for the 'config' registry settings
struct Reg_Config {
	char str_ClientName[SIZE_OF_CLIENTNAME];
	char str_FileDestination[SIZE_OF_DESTINATION];
	int dw_stdout;
	int dw_Syslog;
};

struct Reg_Remote {
	int dw_Allow;
	int dw_WebPort;
	int dw_Restrict;
	char str_RestrictIP[SIZE_OF_RESTRICTIP];
	int dw_Password;
	char str_Password[SIZE_OF_PASSWORD];
};

struct Reg_Objective {
	char str_critic[SIZE_OF_CRITICALITY];
	char str_event_type[SIZE_OF_EVENTLOG];
	char str_eventid_match[SIZE_OF_EVENTIDMATCH];
	char str_user_match[SIZE_OF_USERMATCH];
	char str_general_match[SIZE_OF_GENERALMATCH];
	char str_user_match_type[SIZE_OF_USER_MATCH_TYPE];
	char str_general_match_type[SIZE_OF_GENERAL_MATCH_TYPE];
};


// int          HandleWebPages(char *HTTPBuffer,char *HTTPOutputBuffer,int size);
int HandleWebPages(char *HTTPBuffer, char *HTTPOutputBuffer, int size,
		   int http_listen_socket, int http_message_socket);
int Status_Page(char *source, char *dest, int size);
int DefaultHeader(char *source, char *dest, int size);
int DisplayTextHeader(int http_socket);

int Network_Config(char *source, char *dest, int size);
int Remote_Config(char *source, char *dest, int size);
int Remote_Set(char *source, char *dest, int size);
int Objective_Config(char *source, char *dest, int size);
int DefaultFooter(char *source, char *dest, int size);

int InterSectImage(char *source, char *dest, int size);
int Objective_Display(char *source, char *dest, int size);
// int          Restart(char *source, char *dest, int size);
int Restart(char *source, char *dest, int size, int one, int two);
int Network_Set(char *source, char *dest, int size);
int Objective_Result(char *, char *, int);

FILE *Find_First_Objective();
FILE *Find_First_Network();
int Get_Next_Objective(FILE * configfile, struct Reg_Objective *objective);
int Get_Next_Network(FILE * configfile, struct Reg_Host *host_struct);
int Close_Objective_File(FILE * configfile);

int ReadObjectives();
void DestroyList(void);
int debracket(char *source, char *dest, int length);
int ShowUsers(int http_socket);
int ShowGroups(int http_socket);
int ShowGroupMembers(int http_socket);
int RunJass(int http_socket, char *, char *, int);


// Stuff we use from webserver.h
int base64decode(char *dest, char *src);
char *GetNextArgument(char *source, char *destvar, int varlength,
		      char *destval, int vallength);

void *Load_Config_File();
int Read_Config_From_File(struct Reg_Config *);
void Clear_Config_File(void *location);
int Grab_RAMConfig_Line(char *source, char *dest, int size);

int getnetwork(char *string, char *host, int length, int *protocol);

int Read_Remote_From_File(struct Reg_Remote *remote_struct);

int iswebfilename(char *string);
int isstdout(char *string);
int isnetwork(char *string);

#endif				// _WEBPAGES_H_
