#!/bin/sh
########################################################################
#
#   (c) 2001-2003 Intersect Alliance Pty Ltd
#
#   This script controls the new audit daemon.
#   Note that this script needs to be run before
#   any processes that you wish to audit (eg: dtlogin)
#
#   Version 1.5
#
#   Usage: /etc/init.d/snare { start | stop | restart } 
#
########################################################################

case "$1" in
'start')
        PID=`cat /var/run/snarecore.pid 2>/dev/null`
        if [ ! -z "$PID" ] ;  then
		echo "Snare already running. Please stop Snare first."
		exit 1;
	fi
        if [ -f /etc/security/snarecore -a -f /etc/security/audit_control ] ; then
                echo "Snare starting."
		/etc/security/snarecore
        fi
        ;;
'stop')
	# Turn off auditing. This will also kill SNARE nicely.
	auditconfig -setcond noaudit
	sleep 1
        PID=`cat /var/run/snarecore.pid 2>/dev/null`
       	if [ ! -z "$PID" ] ;  then
		kill ${PID}
	fi
	rm /var/run/snarecore.pid 2>/dev/null
	sleep 1

	# Just in case:
	# Kill all snare processes, sorted on parent process ID
	# This way snare with ppid of 1 gets killed first
        /usr/bin/ps -e -u 0 -o "pid,ppid,comm"|/usr/bin/fgrep snarecor|/usr/bin/egrep -v fgrep|/usr/bin/sort -n +1|/usr/bin/awk '{print $1}' |
		while read pid ppid command; do
			if [ ! -z "$pid" ] ; then
				echo "Cleaning up stale snare process $pid"
				kill ${pid} 1>/dev/null 2>&1
			fi
		done
	exit 1;
        ;;
'restart')
        if [ -f /etc/init.d/snare ] ; then
		/etc/init.d/snare stop
		/etc/init.d/snare start
	fi
	;;
	
*)
        echo "Usage: /etc/init.d/snare { start | stop | restart }"
        ;;
esac

exit 0
