#!/bin/sh
########################################################################
#    
#    (c) 2001-2006 Intersect Alliance Pty Ltd
# 
#   This script will automate the installation of the snare audit daemon.
#   
#   Version 1.8
#    
#    Usage: ./install.sh
#
########################################################################

########################################################################
#   Check that the necessary files are contained within the local
#   directory. 
########################################################################

file_check()
{

     if [ ! -f snarecore.sparc ]
     then
        echo "The program snarecore binary file is missing. Terminating script."
        exit 1
     fi

     if [ ! -f snarecore.x86 ]
     then
        echo "The program snarecore binary file is missing. Terminating script."
        exit 1
     fi

     if [ ! -f snare.conf.basic ]
     then
        echo "The new basic configuration file is missing. Terminating script."
        exit 1
     fi

     if [ ! -f snare.conf.medium ]
     then
        echo "The new medium configuration file is missing. Terminating script."
        exit 1
     fi

     if [ ! -f snare.conf.advanced ]
     then
        echo "The new advanced configuration file is missing. Terminating script."
        exit 1
     fi

     if [ ! -f audit_start.sh ]
     then
        echo "The audit startup script is missing. Terminating script."
        exit 1 
     fi

     if [ ! -f snare_audit_control ]
     then
        echo "The audit control script is missing. Terminating script."
        exit 1 
     fi

     if [ ! -f uninstall.sh ]
     then
        echo "The snare removal script is missing. Terminating script."
        exit 1 
     fi
}

########################################################################
#   Check that the user has an effective userid of 0 (root) 
########################################################################

root_check()
{
     id | grep -c uid=0 > /dev/null
     RETVAL=$?

	if [ $RETVAL -gt 0 ]
	then
           echo "You need to be root to run this script. Terminating script."
           exit 1
        else
           echo "Confirmed that you are logged in as root"
	fi

}

########################################################################
#   Check that the software patch level is OK. The two patches (one 
#   for Solaris 6 and one for Solaris 7. These two scripts MUST
#   be installed.
########################################################################

check_os_and_patch_level()
{
   uname -r | egrep "5.([6-9]|10)" > /dev/null
   RETVAL=$?

   if [ $RETVAL -gt 0 ]
   then
     echo "This updated Solaris daemon is designed for Solaris 6, 7, 8, 9 and 10 only. Terminating script"
     exit 1
   fi 
	
   uname -r | grep 5.6 > /dev/null 
   RETVAL=$?

   if [ $RETVAL -lt 1 ]
   then		
        showrev -p | egrep "^Patch: +105621" > /dev/null
        RETVAL=$?
		
	if [ $RETVAL -gt 0 ]
	then
           echo "You need the Solaris 6 patch 105621 installed. Terminating script"
           exit 1
        else 
           echo "Confirmed you have the necessary Solaris 6 patches" 
	fi
   fi 


   uname -r | grep 5.7 > /dev/null
   RETVAL=$?

   if [ $RETVAL -lt 1 ]
   then
        showrev -p | egrep "^Patch: +106541" > /dev/null
        RETVAL=$?
       
        if [ $RETVAL -gt 0 ]
        then
           echo "You need the Solaris 7 patch 106541 installed. Terminating script"
           exit 1 
        else
           echo "Confirmed you have the necessary Solaris 7 patches"
        fi
   fi

   uname -r | grep 5.8 > /dev/null
   RETVAL=$?

   if [ $RETVAL -lt 1 ]; then
	echo "No additional patches are required for Solaris 8. Continuing."
   fi

   uname -r | grep 5.9 > /dev/null
   RETVAL=$?

   if [ $RETVAL -lt 1 ]; then
	echo "No additional patches are required for Solaris 9. Continuing."
   fi

   uname -r | grep 5.10 > /dev/null
   RETVAL=$?

   if [ $RETVAL -lt 1 ]
   then
	svcs svc:/system/auditd:default > /dev/null 2>&1 
	RETVAL=$?

        if [ $RETVAL -lt 1 ]
	then
		echo "Disabling SMF auditd service. Continuing."
		svcadm disable svc:/system/auditd:default > /dev/null
	else
		echo "No additional patches are required for Solaris 10. Continuing."
	fi
   fi
}

########################################################################
#   Check that the Solaris audit sub-system has been executed. The
#   audit sub-system is installed by executing "bsmconv". This will then
#   add an entry in the /etc/system file, which can be used to check
#   if audit has been installed. 
########################################################################

check_audit_is_on()
{
    cat /etc/system | egrep "c2audit:audit_load *= *1" > /dev/null
    RETVAL=$?
      
    if [ $RETVAL -gt 0 ] 
    then
       echo "The audit sub-system has not been installed."
       echo "Please convert this system to be audit-ready by running"
       echo "bsmconv from /etc/security, then reboot your system."
       echo
       echo "Terminating script"
       exit 1
    else 
       echo "Snare has confirmed that you have the audit sub-system installed"
    fi              
}


########################################################################
#   This routine will copy the key audit_[control|class|event]  
#   and the /etc/init.d/audit files to the /etc/security directory
#   and rename them to ".snare-backup". If they exist, it will not back them up.
#   The point of this approach is to backup the old BSM files, and not
#   the snarecore files. If a recovery is required, the user can then 
#   recover to an old BSM state. 
########################################################################

backup_key_files()
{

   echo "Backing up key files..........."

   if [ ! -f /etc/security/audit.snare-backup ]
   then
      cp /etc/init.d/audit /etc/security/audit.snare-backup
      RETVAL=$?
      if [ $RETVAL -gt 0 ]
      then
        echo "Unable to backup the /etc/init.d/audit file to /etc/security. Terminating script"
        exit 1
      fi
   else
      echo "Backup of audit already exists. Not overwriting"
   fi

   if [ ! -f /etc/security/audit_control.snare-backup ]; then
   	cp /etc/security/audit_control /etc/security/audit_control.snare-backup
   	RETVAL=$?
 	if [ $RETVAL -gt 0 ];then
      		echo "Unable to backup the /etc/init.d/audit_control file to /etc/security. Terminating script"
      		exit 1
   	fi
   else
      echo "Backup of audit_control already exists. Not overwriting"
   fi

   if [ ! -f /etc/security/audit_class.snare-backup ]; then
   	cp /etc/security/audit_class /etc/security/audit_class.snare-backup
   	RETVAL=$?
   	if [ $RETVAL -gt 0 ];then
      		echo "Unable to backup the /etc/init.d/audit_class file to /etc/security. Terminating script"
      		exit 1
   	fi
   else
      echo "Backup of audit_class already exists. Not overwriting"
   fi

   if [ ! -f /etc/security/audit_event.snare-backup ]; then
   	cp /etc/security/audit_event /etc/security/audit_event.snare-backup
   	RETVAL=$?
   	if [ $RETVAL -gt 0 ];then
      		echo "Unable to backup the /etc/init.d/audit_event file to /etc/security. Terminating script"
      		exit 1
   	fi
   else
      echo "Backup of audit_event already exists. Not overwriting"
   fi
}


########################################################################
#  This is the main loop  
########################################################################

check_audit_is_on
file_check 
root_check
check_os_and_patch_level
backup_key_files

INSTAL=0
SNAREC=0

if [ -f /etc/security/snare.conf ]; then
   SNAREC=1
fi

if [ -f /etc/init.d/snare ]; then
	echo "WARNING: It looks as though Snare is already installed."
	echo
	echo "Please uninstall Snare first before proceeding: ./uninstall.sh"
	echo
	exit
fi

# Kill off any outstanding pid files.
if [ -f /var/run/snarecore.pid ]; then
	rm -f /var/run/snarecore.pid >/dev/null 2>&1
fi

while [ "$INSTAL" -ne "1" ] && [ "$INSTAL" -ne "2" ] && [ "$INSTAL" -ne "3" ] && [ "$INSTAL" -ne "4" ]
do
  echo 
  echo "Enter [1] to install a basic starting configuration:"
  echo "  - login/logout, su, password changes, mounts, system reboots"
  echo "  - Recommended for workstations"
  echo "Enter [2] to install an average starting configuration:"
  echo "  - Basic install, plus process execution events"
  echo "  - Recommended for servers"
  echo "Enter [3] to install an advanced starting configuration:"
  echo "  - Normal install, plus file-based auditing"
  if [ "$SNAREC" -eq "1" ]; then
     echo "Enter [4] to preserve the EXISTING snare configuration file"
  fi
  echo "Enter anything else to terminate the script"
  /usr/ucb/echo -n "Selection: "
    read INSTAL
    case $INSTAL in
       1) echo "Installing basic configuration files"; INSTALL_TYPE=1 ;;
       2) echo "Installing average configuration files"; INSTALL_TYPE=2 ;;
       3) echo "Installing advanced configuration files"; INSTALL_TYPE=3 ;;
       4) if [ "$SNAREC" -eq "1" ]; then
		echo "Preserving existing SNARE configuration"
		INSTALL_TYPE=4
	  else
		echo "Script terminating at user request";
		exit 1;
	  fi;;
       *) echo "Script terminating at user request"; exit 1 ;;
    esac 
done
 

########################################################################
#  This provides the final warning before the software is loaded onto
#  the system. In case of mistakes, it allows the user to escape before 
#  the software is loaded.   
########################################################################

echo 
echo "*************************************************"
echo 
echo "You are about to install Snare on this host."
echo "Your selections are as follows:"
if [ $INSTALL_TYPE -eq 1 ]; then
  echo "Basic Installation"
elif [ $INSTALL_TYPE -eq 2 ]; then
  echo "Normal Installation"
elif [ $INSTALL_TYPE -eq 3 ]; then
  echo "Advanced Installation"
else
  echo "Preserving existing configuration file."
fi



########################################################################
#  This will copy the common files to the /etc directory.  
########################################################################

if [ $INSTALL_TYPE -eq 1 ] || [ $INSTALL_TYPE -eq 2 ] || [ $INSTALL_TYPE -eq 3 ] || [ $INSTALL_TYPE -eq 4 ]; then

   # Kill the audit daemon, if it is alive
   /usr/sbin/audit -T > /dev/null 2>&1
   sleep 2

   /etc/init.d/audit stop
   PID=`/usr/bin/ps -e -u 0|/usr/bin/fgrep auditd|/usr/bin/egrep -v fgrep|/usr/bin/awk '{print $1}'`
   if [ ! -z "$PID" ] ;  then
	kill $PID
        sleep 2
   fi

   PID=`/usr/bin/ps -e -u 0|/usr/bin/fgrep auditd|/usr/bin/egrep -v fgrep|/usr/bin/awk '{print $1}'`
   if [ ! -z "$PID" ] ;  then
	# Die die die...
	kill -9 $PID
        sleep 2
   fi

   # Still active??? Ok.. admit defeat.
   PID=`/usr/bin/ps -e -u 0|/usr/bin/fgrep auditd|/usr/bin/egrep -v fgrep|/usr/bin/awk '{print $1}'`
   if [ ! -z "$PID" ] ;  then
        echo "Warning: Cannot terminate the current audit daemon process."
        echo "         Please kill auditd manually, and retry the installation."
	exit
   fi

   echo
   echo "Installing common files..........."

   # Are we on a sparc or x86 arch?
   uname -a | grep i86pc > /dev/null
   if [ $? -eq 0 ]; then
   	cp ./snarecore.x86 /usr/bin/snarecore
   else
	cp ./snarecore.sparc /usr/bin/snarecore
   fi

   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the snarecore program to /usr/bin. Terminating script"
     exit 1
   fi

   chown root:root /usr/bin/snarecore
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to change owner for file to /usr/bin/snarecore. Terminating script"
     exit 1
   fi
   chmod  550 /usr/bin/snarecore
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to change the permissions for file to /usr/bin/snarecore. Terminating script"
     exit 1
   fi

   cp ./audit_start.sh  /etc/init.d/audit
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the startup script: /etc/init.d/audit. Terminating script"
     exit 1
   fi

   cp ./snare_start.sh  /etc/init.d/snare
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the startup script: /etc/init.d/snare. Terminating script"
     exit 1
   fi

   cp ./snare_audit_control /etc/security/audit_control
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the snare audit_control replacement to /etc/security. Terminating script"
     exit 1
   fi

   grep "^0x10000000:" /etc/security/audit_class | egrep -v "0x10000000:ia:" >/dev/null
   RETVAL=$?
   if [ $RETVAL -eq 0 ]; then
	echo "Cannot modify /etc/security/audit_class - there is already"
	echo " a class in existance with a flag setting of 0x10000000."
        echo " Please contact the InterSect Alliance team for assistance."
        exit 1
   fi

   grep "0x10000000:ia:" /etc/security/audit_class >/dev/null
   RETVAL=$?
   if [ $RETVAL -ne 0 ]; then
   	# Modify, but do not overwrite audit_class
   	echo "0x10000000:ia:intersect alliance snare" >> /etc/security/audit_class
   fi

   cat /etc/security/audit_event | nawk -F: '{ print ($1 > 6000) ? $1 ":" $2 ":" $3 ":" $4 ",ia" : $0 }' > /etc/security/audit_event_snare
   mv /etc/security/audit_event_snare /etc/security/audit_event
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to create the snare audit_event replacement in /etc/security. Terminating script"
     exit 1
   fi

   cp uninstall.sh /etc/security/snare_uninstall.sh
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the snare uninstall.sh script to /etc/security. Terminating script"
     exit 1
   fi

   # Are we on a sparc or x86 arch?
   #uname -a | grep i86pc >/dev/null
   #if [ $? -eq 0 ]; then
   #	cp ./snare.x86 /usr/bin/snare
   #else
   #	cp ./snare.sparc /usr/bin/snare
   #fi
   #RETVAL=$?
   #if [ $RETVAL -gt 0 ]
   #then
   #   echo "Unable to copy the SNARE GUI into /usr/bin. Continuing."
   #fi

   ln /etc/init.d/snare /etc/rc0.d/K33snare
   ln /etc/init.d/snare /etc/rc1.d/K33snare
   ln /etc/init.d/snare /etc/rc2.d/S99zsnare
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to create etc/rc*.d files. Terminating script"
     exit 1
   fi

   echo
   echo "Successfully installed the common files"
   echo
fi

	
########################################################################
#  This will copy the basic files to /etc/security
#  It will also change the owner and permissions for these files.
########################################################################

if [ $INSTALL_TYPE -eq 1 ]
then
   echo
   echo "Installing basic configuration files..........."

   cp ./snare.conf.basic /etc/security/snare.conf
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the audit_event file to /etc/security. Terminating script"
     exit 1 
   fi
   chown root:root /etc/security/snare.conf
   chmod 600 /etc/security/snare.conf

fi


########################################################################
#  This will copy the server files to /etc/security, for a
#  average setup. It will also change the owner and permissions
#  for these files.
########################################################################


if [ $INSTALL_TYPE -eq 2 ]
then
   echo
   echo "Installing average configuration files..........."


   cp ./snare.conf.medium /etc/security/snare.conf
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the audit_event file to /etc/security. Terminating script"
     exit 1 
   fi
   chown root:root /etc/security/snare.conf
   chmod 700 /etc/security/snare.conf
fi

if [ $INSTALL_TYPE -eq 3 ]
then
   echo
   echo "Installing average configuration files..........."


   cp ./snare.conf.advanced /etc/security/snare.conf
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the audit_event file to /etc/security. Terminating script"
     exit 1 
   fi
   chown root:root /etc/security/snare.conf
   chmod 700 /etc/security/snare.conf
fi


echo
echo "Successfully installed the necessary files. Activating auditing..."
echo 

/etc/init.d/audit start
/etc/init.d/snare start
sleep 2

PID=`/usr/bin/ps -e -u 0|/usr/bin/fgrep snarecor|/usr/bin/egrep -v fgrep|/usr/bin/awk '{print $1}'`
if [ -z "$PID" ] ;  then
        echo "Snare not running. Please check installation parameters."
        exit 1;
fi

# Stop solaris complaining about auditd at reboot
rm -f /etc/security/audit_data
ln -s /var/run/snarecore.pid /etc/security/audit_data

echo "Done."
echo
if [ $INSTALL_TYPE -ne 4 ]; then
        echo "Snare will also be activated after a reboot via the"
        echo "init.d/snare startup script."
	echo
	echo "Please connect to the local machine using your web browser"
	echo "using the following URL: http://"`hostname`":6161/"
	echo "and a userid and password of 'snare'"
	echo "Once connected, please CHANGE THE DEFAULT PASSWORD, configure"
	echo "any additonal audit objectives you require, and restart"
	echo "the audit server".
	echo ""
else
	echo "Snare has been upgraded. Note that Snare now supports"
	echo "passwords to be in MD5 hash format."
	echo ""
	echo "Recommend that you re-set the password used for snare"
	echo "remote access in order to take advantage of the new"
	echo "password scheme."
fi

exit 0
