#!/bin/sh
########################################################################
#
#   (c) 2001-2006 Intersect Alliance Pty Ltd
#
#   This script controls the new audit daemon.
#   Note that this script needs to be run before
#   any processes that you wish to audit (eg: dtlogin)
#
#   Version 1.7
#
#   Usage: /etc/init.d/snare { start | stop | restart } 
#
########################################################################

case "$1" in
'start')
        PID=`cat /var/run/snarecore.pid 2>/dev/null`
        if [ ! -z "$PID" ] ;  then
		echo "Snare already running. Please stop Snare first."
		exit 1
	fi

	/usr/bin/id | /usr/bin/grep '^uid=0' > /dev/null
	if [ $? -ne 0 ]; then
		echo "Sorry, you need to be root to start snare."
		exit 1
	fi

	# Audit public files.
	/usr/sbin/auditconfig -setpolicy +public >/dev/null 2>&1

        if [ -f /usr/bin/snarecore -a -f /etc/security/audit_control ] ; then
                echo "Snare starting."
		/usr/bin/snarecore
        fi
	exit 0
        ;;
'stop')
	/usr/bin/id | grep '^uid=0' > /dev/null
	if [ $? -ne 0 ]; then
		echo "Sorry, you need to be root to start snare."
		exit 1
	fi

	# Turn off auditing. This will also kill SNARE nicely
	# on solaris <= 9
	/usr/sbin/auditconfig -setcond noaudit >/dev/null 2>&1
	sleep 1
        PID=`cat /var/run/snarecore.pid 2>/dev/null`
       	if [ ! -z "$PID" ] ;  then
		kill -USR1 ${PID}
		sleep 1
		kill ${PID}
	fi
	rm -f /var/run/snarecore.pid 2>/dev/null
	sleep 1

	# Just in case:
	# Kill all snare processes, sorted on parent process ID
	# This way snare with ppid of 1 gets killed first
        /usr/bin/ps -e -u 0 -o "pid,ppid,comm"|/usr/bin/egrep "(snarecor|praudit)" |/usr/bin/egrep -v egrep|/usr/bin/sort -n +1|/usr/bin/awk '{print $1}' |
		while read pid ppid command; do
			if [ ! -z "$pid" ] ; then
				echo "Cleaning up stale snare process $pid"
				kill ${pid} 1>/dev/null 2>&1
			fi
		done
	exit 0
        ;;
'restart')
        if [ -f /etc/init.d/snare ] ; then
		/etc/init.d/snare stop
		RC=$?
		if [ $RC -gt 0 ]; then
			exit $RC
		fi
		/etc/init.d/snare start
		RC=$?
		if [ $RC -gt 0 ]; then
			exit $RC
		fi
	fi
	;;
	
*)
        echo 'Usage: /etc/init.d/snare { start | stop | restart }'
        ;;
esac

exit 0
