#!/bin/sh

########################################################################
#    
#    (c) 2001-2007 Intersect Alliance Pty Ltd
# 
#   This script will automate the installation of the snare audit daemon.
#   
#   Version 1.1
#    
#    Usage: ./uninstall.sh
#
########################################################################

########################################################################
#   Check that the user has an effective userid of 0 (root) 
########################################################################

root_check()
{
     id | grep -c uid=0 > /dev/null
     RETVAL=$?

	if [ $RETVAL -gt 0 ]
	then
           echo "You need to be root to run this script. Terminating script."
           exit 7
        else
           echo "Confirmed your are logged in as root"
	fi

}

########################################################################
#   This routine will copy the key audit_[control|class|event]  
#   and the /etc/init.d/audit files to the /etc/security directory
#   and rename them to ".snare-backup". If they exist, it will not back them up.
#   The point of this approach is to backup the old BSM files, and not
#   the snarecore files. If a recovery is required, the user can then 
#   recover to an old BSM state. 
########################################################################

restore_key_files()
{
if [ -f /usr/bin/svcs ]; then
   svcs svc:/system/auditd:default > /dev/null 2>&1 
   SMFAUDITD=$?
else
   SMFAUDITD=1
fi
   echo "Restoring key files..........."

   if [ $SMFAUDITD -ne 0 ]; then
	   echo "Restoring oringinal /etc/init.d/audit..."
	   if [ -f /etc/security/audit.snare-backup ]
	   then
	      cp /etc/security/audit.snare-backup /etc/init.d/audit
	      RETVAL=$?
	      if [ $RETVAL -gt 0 ]
	      then
		echo "Unable to restore /etc/init.d/audit to its original value."
	      fi
	   else
		echo "Cannot find /etc/init.d/audit.snare-backup. Cannot restore."
	   fi 
   fi

   echo "Restoring oringinal /etc/init.d/audit_control..."
   if [ -f /etc/security/audit_control.snare-backup ]
   then
      cp /etc/security/audit_control.snare-backup /etc/security/audit_control
      RETVAL=$?
      if [ $RETVAL -gt 0 ]
      then
        echo "Unable to restore /etc/security/audit_control to its original value."
      fi
   else
	echo "Cannot find /etc/security/audit_control.snare-backup. Cannot restore."
   fi 

   echo "Restoring oringinal /etc/security/audit_class..."
   if [ -f /etc/security/audit_class.snare-backup ]
   then
      cp /etc/security/audit_class.snare-backup /etc/security/audit_class
      RETVAL=$?
      if [ $RETVAL -gt 0 ]
      then
        echo "Unable to restore /etc/security/audit_class to its original value."
      fi
   else
	echo "Cannot find /etc/security/audit_class.snare-backup. Cannot restore."
   fi 

   echo "Restoring oringinal /etc/security/audit_event..."
   if [ -f /etc/security/audit_event.snare-backup ]
   then
      cp /etc/security/audit_event.snare-backup /etc/security/audit_event
      RETVAL=$?
      if [ $RETVAL -gt 0 ]
      then
        echo "Unable to restore /etc/security/audit_event to its original value."
      fi
   else
	echo "Cannot find /etc/security/audit_event.snare-backup. Cannot restore."
   fi 

   echo "Removing snarecore binary..."
   if [ -f /usr/bin/snarecore ]
   then
	rm /usr/bin/snarecore 2>/dev/null
        echo "Done."
   fi

   if [ -f /usr/bin/snare ]
   then
        echo "Removing snare GUI binary..."
        rm /usr/bin/snare 2>/dev/null
        echo "Done."
   fi

   if [ -f /var/svc/manifest/application/security/snare.xml ]
   then
        echo "Removing snare SMF script..."
        rm /var/svc/manifest/application/security/snare.xml 2>/dev/null
        echo "Done."
   fi

   echo "Removing snare backup files."
   rm -f /etc/security/*.snare-backup
   echo "Done."

   echo "I will leave the snare configuration file (/etc/security/snare.conf) - please remove it manually if you intend to permanently remove SNARE..."
}

if [ -f /usr/bin/svcs ]; then
   svcs svc:/system/auditd:default > /dev/null 2>&1 
   SMFAUDITD=$?
else
   SMFAUDITD=1
fi
if [ $SMFAUDITD -ne 0 ]; then
	/etc/init.d/snare stop
	/etc/init.d/audit stop
else
	svcadm disable snare
	svccfg delete snare
fi

root_check
restore_key_files

# Remove the snare-specific startup scripts
if [ $SMFAUDITD -ne 0 ]; then
	rm /etc/init.d/snare 2>/dev/null
	rm /etc/rc0.d/K33snare 2>/dev/null
	rm /etc/rc1.d/K33snare 2>/dev/null
	rm /etc/rc2.d/S99zsnare 2>/dev/null
else
	rm /lib/svc/method/svc-snare 2>/dev/null
fi

# remove documentation
if [ -d /usr/share/doc/snare-for-solaris ]; then
	rm /usr/share/doc/snare-for-solaris/doc/*
	rmdir /usr/share/doc/snare-for-solaris/doc 2>/dev/null
	rmdir /usr/share/doc/snare-for-solaris 2>/dev/null
	rmdir /usr/share/doc 2>/dev/null
fi

rm -f /var/run/snarecore.pid 2>/dev/null
rm -f /etc/security/snare_uninstall.sh

if [ $SMFAUDITD -eq 0 ]; then
	echo
	echo "If you would like to use the SMF auditd service, please"
	echo "disable BSM (/etc/security/bsmunconv), apply the"
	echo "appropriate Kernel Updates and run the following"
	echo "command:"
	echo
	echo "svcadm enable svc:/system/auditd:default"
	echo
fi
