#!/usr/bin/perl
# $Id: conf-convert.pl,v 1.2 1999/02/26 19:00:56 bazsi Exp $

use English;

$infile=$ARGV[0];
$filtcount = 0;
$destcount = 0;
$matchcount = 0;
$domatch = -1;

sub psrc {
	if ($domatch != -1) {
		print "log { source src; filter m$domatch;";
	} else {
		print "log { source src;";
	}
}

print "# $infile converted\n";
print "#\n\n";
print "source src { udp 0.0.0.0,514; unix-stream /dev/log; };\n";
print "#\n";

while(1) {
	$_ = <>;
	s/([^#]*)#.*/$1/;
	s/^[ \t]*(.*?)[ \t]*$/$1/;
	chomp($line = $_);
	while ($_ && /.*\\$/) {
		chop($line);
		$_ = <>;
		s/([^#]*)#.*/$1/;
		s/^[ \t]*(.*?)[ \t]*$/$1/;
		chomp($line=$line.$_);
	}
	last if (!$_);
	next if (!$line);
	&processline($line);
}


sub processline {

	$_ = $_[0];

	print "#\n# $_\n#\n";
	if (/^\!.*/) {
		s/^\!//;
		s/^\s*(\S*)/$1/;
		print "filter m$matchcount {";
		print " match-prog $_; };\n";
		$domatch = $matchcount;
		$matchcount++;
		next;
	}
	@F = split;
	$dest = $F[$#F];
	if (!defined($destinations{$dest})) {
		print "destination d$destcount {";
		if ($dest =~ /^[-\/].*/) {
			($prefix, $file) = $dest =~ /^([-]?)(.*)/;
			print " file $file ";
			if ($prefix eq "-") {
				print "sync 0 ";
			}
		} elsif ($dest =~ /^\@/) {
			$dest =~ s/^\@//;
			print " udp $dest,514";
		} else {
			print " user $dest";
		}
		$destinations{$dest} = $destcount;
		print "; };\n";
		$destcount++;
	}

	@D = split(/;/, $F[0]);
	foreach $d (@D) {
		$d =~ s/\./,/;
		@fp = split(/,/, $d);
		# lookout for wildcards
		if ( $fp[0] =~ /^\*$/ && $fp[1] =~ /^\*$/) {
			&psrc;
			print " destination d$destinations{$dest}; };\n";
		} elsif ( $fp[0] =~ /^\*$/ ) {
			if (!defined($filters{$d})) {
				$filters{$d} = $filcount;
				print "filter f$filcount {";
				print " priority $fp[1]; };\n";
				$filcount++;
			}
			&psrc;
			print " filter f$filters{$d};";
			print " destination d$destinations{$dest}; };\n";
		} elsif ( $fp[1] =~ /^\*$/ ) {
			if (!defined($filters{$d})) {
				$filters{$d} = $filcount;
				print "filter f${filcount} {";
				print " facility $fp[0]; };\n";
				$filcount++;
			}
			&psrc;
			print " filter f$filters{$d};";
			print " destination d$destinations{$dest}; };\n";
		} else {
			if (!defined($filters{$d})) {
				$filters{$d} = $filcount;
				print "filter f$filcount {";
				print " facpri $d; };\n";
				$filcount++;
			}
			&psrc;
			print " filter f$filters{$d};";
			print " destination d$destinations{$dest}; };\n";
		}
	}
	return 0;
}