/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#include "afdoor.h"

#ifdef USE_SUN_DOORS

#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <door.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <syslog.h>

#include "log.h"

#ifndef lint
static const char rcsid[]="$Id: afdoor.c,v 1.7 1999/01/12 16:51:45 bazsi Exp $";
#endif

void afdoor_server_proc(void *cookie, char *argp, size_t arg_size, door_desc_t *dp, size_t n_desc)
{
	char buf[MAXLINE + 1];
	logmsgtype_t lm;

	strncpy(buf, argp, arg_size);
	log_printall(buf, arg_size, ftable_get_fte(*(int *) cookie));
	return;
}

void
afdoor_open_door(ds)
	doorspec_t *ds;
{
	struct stat st;
	int fd = -1, rc;

	ds->ds_fd = -1;
	rc = stat(ds->ds_path, &st);
	if (rc == -1) {
		fd = creat(ds->ds_path, 0666);
		if (fd == -1) {
			log_printf(LOG_SYSLOG | LOG_ERR, "cannot create sun-door %s: %s", ds->ds_path, strerror(errno));
			return;
		}
		close(fd);
	}
	fdetach(ds->ds_path);
	fd = door_create(afdoor_server_proc, &ds->ds_fd, 0);
	if (fd == -1) {
		log_printf(LOG_SYSLOG | LOG_ERR, "cannot initialize door server %s\n", ds->ds_path);
		return;
	}
	fattach(fd, ds->ds_path);
	ds->ds_fd = fd;
}

void
afdoor_close_door(ds)
	doorspec_t *ds;
{
	door_revoke(ds->ds_fd);
	free(ds->ds_path);
	free(ds);
}

#endif
