/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __AFINET_H
#define __AFINET_H

#include "config.h"
#include "ftable.h"

typedef struct netspec {
	struct netspec *ns_next;
	int ns_fd;
	int ns_mode;
	int ns_cnt;
	int ns_type;
	int ns_proto;
	struct sockaddr_in ns_sin;
	void *ns_proto_state;
} netspec_t;

extern	netspec_t	*nslist;

#define NET_TCP				2
#define NET_UDP				3

extern	int	afinet_check_fd		__P((int, filetable_entry_t *));
extern	int 	afinet_reconnect	__P((filetype_t *));
extern	int	afinet_getsecret	__P((struct sockaddr_in *sin, char **secret, size_t *secretlen));
extern	void	afinet_open_socket	__P((netspec_t *ns));

#endif
