/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#include "afpipe.h"

#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <syslog.h>
#include <errno.h>
#include <string.h>

#include "syslog-ng.h"
#include "log.h"
#include "utils.h"

#ifndef lint
static const char rcsid[]="$Id: afpipe.c,v 1.12 1999/01/12 16:51:45 bazsi Exp $";
#endif

int
afpipe_open_pipe(cm)
	cmdspec_t *cm;
{
	int fd[2];
	pid_t pid;

	pipe(fd);
	pid = fork();
	if (pid == 0) {
		close(fd[1]);
		dup2(fd[0], 0);
		execl("/bin/sh", "/bin/sh", "-c", cm->cm_path, NULL);
	} else 
	if (pid > 0) {
		close(fd[0]);
		fcntl(fd[1], F_SETFD, fcntl(fd[1], F_GETFD, 0) | FD_CLOEXEC);
		cm->cm_fd = fd[1];
	} else {
		log_printf(LOG_SYSLOG | LOG_ERR, "error opening pipe(), cannot fork(): %s\n", strerror(errno));
		return -1;
	}
	return 0;
}

int 
afpipe_output(lg, fte)
	logmsg_t *lg;
	filetable_entry_t *fte;
{
	char line[MAXLINE + 1];
	cmdspec_t *cm = fte->fte_spec;
	int nw;
	
	snprintf(line, sizeof(line), "%s %s %s\n", lg->lg_time, lg->lg_host, lg->lg_line);
	if (opts & OPT_DEBUG)
		log_debug("msg to pipe %s\n",
			cm->cm_path);
	if (cm->cm_fd >= 0) {
		nw = write(cm->cm_fd, line, strlen(line));
		if (nw < 0) {
			log_printf(LOG_SYSLOG | LOG_ERR, "error sending to cmd %s: %s, reopening", cm->cm_path, strerror(errno));
			close(cm->cm_fd);
			ftable_del_fd(cm->cm_fd);
			cm->cm_fd = -1;
			return -1;	/* indicate unsuccessful completition */
		}
	}
	else {
		return -1;
	}
	return 0;
}

int
afpipe_reconnect(ft)
	filetype_t *ft;
{
	cmdspec_t *cm = ft->ft_ptr;
	
	afpipe_open_pipe(cm);
	ftable_add_fd(cm->cm_fd, ft->ft_owner, ft->ft_ndx, ft->ft_type, ft->ft_ptr);
	return 0;
}

int
afpipe_check_fd(fd, fte)
	int fd;
	filetable_entry_t *fte;
{
	filetype_t *ftype;

	switch (VAR_TYPE(fte->fte_type)) {
	case DEST_CMD:
		ftype = &fte->fte_owner->v_list[fte->fte_ndx];
		if (log_queue_run(ftype, (log_output_func_t) afpipe_output, fte)) {
			ftable_del_write_fd(((cmdspec_t *) fte->fte_spec)->cm_fd);
		}
		break;
	}
	return 0;
}
