/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __AFUNIX_H
#define __AFUNIX_H

#include "config.h"

#include <sys/socket.h>
#include <sys/un.h>

#include "ftable.h"

typedef struct unixspec {
	struct unixspec *xs_next;
	int xs_cnt;
	int xs_fd;
	int xs_mode;
	int xs_type;
	int xs_proto;		/* stream or dgram */
	struct sockaddr_un xs_un;
} unixspec_t;

#define NET_UNIX_DGRAM  		0
#define NET_UNIX_STREAM			1

extern	unixspec_t	*xslist;

#define	UNSZ	sizeof(((struct sockaddr_un *)0)->sun_path)

extern	int	afunix_check_fd		__P((int, filetable_entry_t *));
extern	int	afunix_reconnect	__P((filetype_t *));
extern	void	afunix_open_socket	__P((unixspec_t *xs));

#endif
