/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __CONFIG_H
#define __CONFIG_H

#include <sys/param.h>
#include <sys/types.h>  

/* for a detailed function of each #define we use here, see below */

#ifdef __LINUX__
#define USE_STDARG
#define USE_POSIX_REGEX
#define USE_GETUTENT
#endif

#ifdef __BSD__
#define USE_STDARG
#define USE_POSIX_REGEX
#define USE_LOG_UNIX_DGRAM
#endif

/* for solaris 2.6 or later */
#ifdef __SUNOS26__
#define USE_STDARG
#define USE_POSIX_REGEX
#define USE_M4_PREPROCESS
#define USE_GETUTENT
#define USE_SUN_STREAMS
#define USE_SUN_DOORS
#define USE_PTHREADS
#define _REENTRANT
#endif

#ifdef __SUNOS25__
#define USE_STDARG
#define USE_POSIX_REGEX
#define USE_M4_PREPROCESS
#define USE_GETUTENT
#define USE_SUN_STREAMS
#define snprintf __snprintf
#define vsnprintf __vsnprintf
#endif

/* for a detailed function of each #define we use here, see below */
#ifdef __AIX__
#define USE_STDARG
#define USE_POSIX_REGEX
#define USE_LOG_UNIX_DGRAM
#define USE_GETUTENT
#define PATH_DEV_LOG          "/dev/log"
#endif

/* use standard posix stdarg.h instead of varargs.h */ 
/* #define USE_STDARG */

/* use new posix regex lib regex.h instead of regexp.h */
/* #define USE_POSIX_REGEX */

/* use m4 for preprocessing old config file */
/* #define USE_M4_PREPROCESS */

/* use SOCK_DGRAM on unix sockets, when reading old config file */
/* #define USE_LOG_UNIX_DGRAM */

/* have getutent() */
/* #define USE_GETUTENT */

/* whether we should use sun streams */
/* #define USE_SUN_STREAMS */

/* unix socket name */
#ifdef __BSD__
#define PATH_DEV_LOG		"/var/run/log"
#endif

#ifndef PATH_DEV_LOG
#define PATH_DEV_LOG		"/dev/log"
#endif

/* kernel log */
#ifdef __LINUX__
#define PATH_KLOG		"/proc/kmsg"
#else
#define PATH_KLOG		"/dev/klog"
#endif

/* random number generator */
#define PATH_RANDOM		"/dev/random"

#ifdef USE_M4_PREPROCESS
#define PATH_M4 "/usr/bin/m4"
#endif

/****************************************************************************
 * NO MODIFICATION REQUIRED BELOW THIS PART
 * Authorized personell only
 ****************************************************************************/

/* define BSD style parameter expansion macro */
#ifndef	__P
# ifdef __STDC__
#  define	__P(x)	x
# else
#  define	__P(x)	()
#  define	const
# endif
#endif

#define	NEW(x)	(x) = (void *)calloc(1, sizeof(*x))

#ifndef	MIN
# define	MIN(a,b)	((a) < (b) ? (a) : (b))
#endif

#ifndef MAX
# define	MAX(a,b)	((a) > (b) ? (a) : (b))
#endif

#define	SYSLOG_DIR	"/etc/syslog-ng"
#define	SYSLOG_CONF	"/etc/syslog-ng/syslog-ng.conf"
#define	SYSLOG_PID	"/var/run/syslog-ng.pid"
#define	SYSLOG_LOGDIR	"/var/log"
#define	SYSLOG_SECRET	"/etc/syslog-ng/secret"

#define MAX_FILE_SALT	128

#define MAXLOGQUEUE	1000

#define	MARKFREQ	20 * 60 /* seconds between marks */
#define	SYNCFREQ	1

#define	NOPRI		0x10	/* the "no priority" priority */

#define	MAXLINE		1024		/* max. length of a log entry */

#define HASH_WRITE_INTERVAL	120		/* flush h0 in every two minutes */

#define CONNECT_TIMEOUT	2		/* two seconds for new connect timeout */

#ifndef SYSLOGNG_VERSION
#define SYSLOGNG_VERSION "3.00b"
#endif

#endif
