/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __LOG_H
#define __LOG_H

#include "config.h"
#include "syslog-ng.h"

#include "cfgdefs.h"

#include "ftable.h"


typedef struct logmsgtype	{
	struct filetable_entry *lm_fte;	/* source of message */
	int lm_flags;
	struct logmsg *lm_log;
	/* struct sockaddr *lm_saddr; */
} logmsgtype_t;

#define	lm_line		lm_log->lg_line
#define	lm_host		lm_log->lg_host
#define	lm_prog		lm_log->lg_prog
#define lm_time		lm_log->lg_time
#define	lm_len		lm_log->lg_len		/* length of message */
#define	lm_pri		lm_log->lg_pri		/* combination of facility and priority */
#define	lm_recvd	lm_log->lg_recvd	/* when it was received */

#define	FLG_USER	0x01
#define	FLG_SYS		0x02	/* should only be set if from /dev/klog */
#define	FLG_ALL		(FLG_USER|FLG_SYS)
#define	FLG_ADDDATE	0x04	/* need to add the date to the message */
#define FLG_ADDHOST	0x08
#define	FLG_MARK	0x10
#define	FLG_INT		0x20	/* internally generated message */
#define	FLG_HTCP	0x40	/* hashed TCP message received */

typedef int (*log_output_func_t) __P((logmsg_t *, void *));

extern	logmsg_t	*new_logmsg 		__P((char *));
extern	void		free_logmsg 		__P((logmsg_t **));

extern	void		log_fakemsg 		__P((logmsgtype_t *));
extern	int		log_queue_run  		__P((filetype_t *, log_output_func_t, void *));
extern	void		log_timeout_marks	__P((void));
extern	void		log_timeout_dups	__P((void));

#ifdef USE_STDARG
extern	void		log_debug(char *fmt, ...);
extern	void		log_printf(int pri, char *fmt, ...);
#else
extern	void		log_debug();
extern	void		log_printf();
#endif

extern	void		logmsg __P((logmsgtype_t *));
extern	logmsg_t *	log_queue_get	__P((filetype_t *));
extern	void		log_printall __P((char *, int, filetable_entry_t *));

#endif
