/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __AFFILE_H
#define __AFFILE_H

#include "config.h"
#include "ftable.h"
#include "hash.h"

typedef struct filespec {
	struct filespec *fs_next;
	int fs_cnt;	/* reference count */
	u_int fs_lcnt;	/* line count (lines written) */
	int fs_mode;	/* opening mode of the file. */
	int fs_fd;	/* fd to the open file */
	int fs_hfd;	/* fd to the open hash file */
	int fs_written;	/* how many entries written since last fsync ? */
	char *fs_path;	/* path to the log file */
	int fs_syncfreq;
	int fs_markfreq;
	hashalgo_t *fs_hashing;	/* pointer to struct with info. about hashing */
	char fs_h0_dirty;
	char fs_phash[MAX_DIGEST_LEN];	/* hash of the previous line */
	int fs_phlen;	/* length of the previous line */
} filespec_t;

extern	filespec_t	*fslist;

#define	FILE_DOHASH(x)	VAR_DOHASH((x)->fs_mode)

typedef	struct	hashrec {
	char	hr_mac[MAX_DIGEST_LEN];
	long	hr_lcnt;
} hashrec_t;

extern	int	affile_check_fd		__P((int, filetable_entry_t *));
extern	int	affile_reconnect	__P((filetype_t *));
extern	int	affile_open_file	__P((filespec_t *));
extern	void	affile_hash_flush	__P((int));

#endif

