/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#include "afstreams.h"

#ifdef USE_SUN_STREAMS

#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stropts.h>
#include <sys/strlog.h>
#include <errno.h>
#include <string.h>
#include <syslog.h>

#include "log.h"

#ifndef lint
static const char rcsid[]="$Id: afstreams.c,v 1.13 1999/01/12 16:51:45 bazsi Exp $";
#endif

void
afstreams_open_stream(ss)
	streamspec_t *ss;
{
	int fd = -1;
	struct strioctl ioc;

	ss->ss_fd = -1;
	fd = open(ss->ss_path, O_RDONLY);
	if (fd == -1)
		log_printf(LOG_SYSLOG | LOG_ERR, "cannot open sun-stream %s: %s", ss->ss_path, strerror(errno));
	else {
		fcntl(fd, F_SETFD, fcntl(fd, F_GETFD, 0) | FD_CLOEXEC);
		memset(&ioc, 0, sizeof(ioc));
/*
		ioc.ic_cmd = I_ERRLOG;
		if (ioctl(fd, I_STR, &ioc) < 0) {
			log_printf(LOG_SYSLOG | LOG_ERR, "cannot enable error logging on sun-stream %s: %s\n", ss->ss_path, strerror(errno));
			close(fd);
			return;
		}
*/
		ioc.ic_cmd = I_CONSLOG;
		if (ioctl(fd, I_STR, &ioc) < 0) {
			log_printf(LOG_SYSLOG | LOG_ERR, "cannot enable console logging on sun-stream %s: %s\n", ss->ss_path, strerror(errno));
			close(fd);
			return;
		}
	}
	ss->ss_fd = fd;
}

int
afstreams_check_fd(fd, fte)
	int fd;
	filetable_entry_t *fte;
{
	streamspec_t *ss = (streamspec_t *) fte->fte_spec;
	logmsgtype_t lm;
	struct strbuf ctl, data;
	struct log_ctl lc;
	int len, *params, flags;
	char buf[MAXLINE + NLOGARGS * sizeof(int) + 1], buf2[MAXLINE];

	ctl.maxlen = ctl.len = sizeof(lc);
	ctl.buf = (char *) &lc;
	
	data.maxlen = sizeof(buf);
	data.len = 0;
	data.buf = buf;
	flags = 0;
	if (getmsg(ss->ss_fd, &ctl, &data, &flags) == 0) {
		snprintf(buf2, sizeof(buf2), "<%d>", lc.pri);
		len = strlen(buf) + 1;
		len += len % sizeof(int) ? sizeof(int) - len % sizeof(int) : 0;
		params = (int *) (buf + len);
		len = strlen(buf2);
		
		/* this may crash us, if the format string contains %s ...
		   todo: write our own, limited sprintf-like function 
		snprintf(buf2 + len, sizeof(buf2) - len, buf, 
			*params, *(params+1), *(params+2));*/
			
		strncpy(buf2 + len, buf, sizeof(buf2) - len);
		lm.lm_log = new_logmsg(buf2);
		lm.lm_fte = fte;
		lm.lm_flags = FLG_USER;
		lm.lm_recvd = lc.ttime;
		logmsg(&lm);
	}
	return 0;
}

#endif
