/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#include "afuser.h"

#include <utmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <syslog.h>

#include "var.h"
#include "log.h"

int afuser_output_avail = 0;

static int
afuser_output(lg, us)
	logmsg_t *lg;
	userspec_t *us;
{
	char line[40], greet[80], buf[MAXLINE + 1];
	int fd;
#ifdef USE_GETUTENT
	struct utmp *ut;
#else
	struct utmp ut;
	FILE *fp = fopen(_PATH_UTMP, "rb");
	
	if (!fp) return 0;
#endif

	if (opts & OPT_DEBUG)
		log_debug("msg to user: %s\n", us->us_user);

	/*
	 * If it's a "WALL" message (to *) then prepend a small message
	 * about where the message is coming from.
	 */
	if (!strcmp("*", us->us_user)) {
		snprintf(greet, sizeof(greet),
			 "\r\n\7Message from syslogd@%.16s at %s ...\r\n\r\n",
			 lg->lg_host, lg->lg_time);
		snprintf(buf, sizeof(buf), "%s\r\n", lg->lg_line);
	}
	else {
		greet[0] = 0;
		snprintf(buf, sizeof(buf), "%s %s %s\r\n", lg->lg_time, lg->lg_host, lg->lg_line);
	}

	/*
	 * Scan utmp file for people who are logged in.
	 */
#ifdef USE_GETUTENT
	while ((ut = getutent())) {
		if (!*ut->ut_name || !*ut->ut_line)
			continue;
		if (strncmp(ut->ut_name, us->us_user, sizeof(us->us_user) - 1) &&
		    strncmp("*", us->us_user, sizeof(us->us_user) - 1))
			continue;
		snprintf(line, sizeof(line), "/dev/%s", ut->ut_line);
		/*
		 * Attempt to prevent it hanging on opening a tty.
		 */
		alarm(1);
		fd = open(line, O_WRONLY|O_APPEND);
		alarm(0);
		if (fd == -1)
			continue;
		alarm(1);
		write(fd, greet, strlen(greet));
		write(fd, buf, strlen(buf));
		alarm(0);
		close(fd);
	}
	endutent();
#else
	while (fread(&ut, 1, sizeof(ut), fp)) {
		if (!*ut.ut_name || !*ut.ut_line)
			continue;
		if (strncmp(ut.ut_name, us->us_user, sizeof(us->us_user) - 1) &&
		    strncmp("*", us->us_user, sizeof(us->us_user) - 1))
			continue;
		snprintf(line, sizeof(line), "/dev/%s", ut.ut_line);
		/*
		 * Attempt to prevent it hanging on opening a tty.
		 */
		alarm(1);
		fd = open(line, O_WRONLY|O_APPEND);
		alarm(0);
		if (fd == -1)
			continue;
		alarm(1);
		write(fd, greet, strlen(greet));
		write(fd, buf, strlen(buf));
		alarm(0);
		close(fd);
	}
	fclose(fp);
#endif
	return 0; /* message delivered */
}

int
afuser_check_users()
{
	int cnt;
	void *ptr;
	sdlist_t *s;

	if (afuser_output_avail) {
		ptr = NULL;
		cnt = 0;
		while (next_dfd(&ptr, &cnt) != -2) {
			s = (sdlist_t *)ptr;
			if (s->sd_dst->v_list[cnt - 1].ft_type == DEST_USER) {
				while (log_queue_run(&s->sd_dst->v_list[cnt - 1], (log_output_func_t) afuser_output, s->sd_dst->v_list[cnt - 1].ft_ptr) == 0) 
					;
			}
		}
		afuser_output_avail = 0;
	}
	return 0;
}
