/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __CFGDEFS_H
#define __CFGDEFS_H

typedef	struct	logmsg	{
	char 	*lg_line;
	char	*lg_time;
	char	*lg_host;
	char	*lg_prog;
	int	lg_ref;
	int	lg_pri;
	time_t	lg_recvd;
} logmsg_t;

/* source, filter or destination */
typedef struct var {
	struct var *v_next;
	char *v_name;
	int v_type;
	int v_cnt;
	int v_num;
	struct filetype *v_list;
} var_t;

extern	var_t		*vlist;

#define	VAR_SRC	1
#define	VAR_FIL	2
#define	VAR_DST	3

typedef void spec_t;

/* these are entries in a variable */
typedef	struct	filetype	{
	var_t *ft_owner;
	int ft_ndx;
	int ft_type;		/* the type of this entry */
	spec_t *ft_ptr;		/* depending on type contains filespec_t, unixspec_t etc. */
	logmsg_t *ft_logqueue[MAXLOGQUEUE];
	logmsg_t *ft_lastentry;
	int ft_wrptr;
	int ft_rdptr;
	time_t ft_lasttime;
	int ft_mcount;
} filetype_t;

#define	ft_line	ft_lastentry->lg_line
#define	ft_host	ft_lastentry->lg_host
#define	ft_prog	ft_lastentry->lg_prog
#define	ft_len	ft_lastentry->lg_len
#define	ft_pri	ft_lastentry->lg_pri
#define	ft_firsttime	ft_lastentry->lg_recvd

/* structure representing the log statement */
typedef struct sdlist {
	struct sdlist *sd_next;
	var_t *sd_src;			/* source */
	var_t *sd_dst;			/* destination */
	struct fillist *sd_fil;		/* filter list */
} sdlist_t;

extern sdlist_t *sdlist;    /* linked lists of all log statements */


#define	DEST_NONE	0x20
#define	DEST_FILE	0x21
#define	DEST_INET	0x22
#define	DEST_UNIX	0x23
#define	DEST_CMD	0x24
#define	DEST_USER	0x25

#define	SRC_NONE	0x40
#define	SRC_FILE	0x41
#define	SRC_INET	0x42
#define SRC_INET_ACCEPTED 0x43
#define	SRC_UNIX	0x44
#define SRC_UNIX_ACCEPTED 0x45
#define SRC_SUN_STREAM	0x46		/* sun solaris streams */
#define SRC_SUN_DOOR	0x47

#define	FIL_NONE	0x80
#define	FIL_FAC		0x81
#define	FIL_PRI		0x82
#define	FIL_FACPRI	0x83
#define	FIL_WRAP	0x84
#define	FIL_MATCH	0x85
#define	FIL_MATCHFILE	0x86
#define	FIL_MATCHPROG	0x87
#define	FIL_CMD		0x88

#define	VAR_TMSK	(DEST_NONE|SRC_NONE|FIL_NONE)
#define	VAR_WHICH	0x1f
#define	VAR_MODE(x)	((x) & VAR_TMSK)
#define	VAR_DSF		(VAR_TMSK|VAR_WHICH)
#define	VAR_TYPE(x)	((x) & VAR_DSF)
#define	VAR_OLD		0x100
#define	VAR_RAW		0x200
#define	VAR_HASH	0x400

#define	VAR_DOHASH(x)	((x) & VAR_HASH)

#endif
