/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#include "cfgfile.h"

#include <stdio.h>

#include "syslog-ng.h"
#include "var.h"
#include "y.tab.h"

#if !defined(lint)
static const char rcsid[] = "$Id: cfgfile.c,v 1.14 1998/12/10 20:16:42 bazsi Exp $";
#endif

extern int yyparse __P((void));

/*
 * read in the configuration file
 */
int
read_config(file)
	char *file;
{
	FILE *fp;

	fp = fopen(file, "r");
	if (fp) {
		yyin = fp;
		if (yyparse() != 0) {
			if (!feof(fp) && yyparse() == 0) {
				fclose(fp);
				return 0;
			}
			fclose(fp);
			return -1;
		}
		fclose(fp);
	}
	else {
		return -1;
	}

	/*
	 * Redisplay the configuration file as we see it.
	 */
	if (opts & (OPT_DEBUG|OPT_VERBOSE))
		dump_all();

	return 0;
}


