/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __FTABLE_H
#define __FTABLE_H

#include "config.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "cfgdefs.h"

/* global file table, contains all opened files, indexed by fd */
typedef struct filetable_entry {
	var_t *fte_owner;	/* ptr to owner variable */
	int fte_ndx;		/* ndx to filetype */
	int fte_type;		/* spec type */
	void *fte_spec;		/* ptr to spec */
	char *fte_part;		/* ptr to the glued parts of the received message */
} filetable_entry_t;

extern	void	ftable_init			__P((void));
extern	void	ftable_reinit			__P((void));
extern	void 	ftable_done			__P((void));
extern	void	ftable_add_read_fd		__P((int));
extern	void	ftable_del_read_fd		__P((int));
extern	void	ftable_add_write_fd		__P((int));
extern	void	ftable_del_write_fd		__P((int));
extern	void	ftable_add_fd			__P((int, var_t *, int, int, spec_t *));
extern	void	ftable_del_fd			__P((int));
extern	int	ftable_check_fd			__P((int));
extern	int	ftable_check_fds		__P((time_t));
extern	filetable_entry_t *ftable_get_fte	__P((int));

#endif
