/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#include "config.h"

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include "hash.h"
#include "utils.h"

void usage(void)
{
	printf( "genh0 - generates initial hash for a log file\n"
		"usage:\n"
		"  genh0 [options] files...\n\n"
		"options:\n"
		"  -p <password>     don't ask for password, instead use the one given here\n"
		"  -h <hashtype>     specify hash type, currently only SHA1 is supported\n");
}

int main(int argc, char *argv[])
{
	char password[50], buf[256], salt[MAX_FILE_SALT];
	char hashtype[50] = "SHA1";
	hashalgo_t *hash;
	char digest[MAX_DIGEST_LEN];
	int opt;
	int lcnt, i, askpass = 1;
	FILE *fd;
	
	while ((opt = getopt(argc, argv, "p:h:")) != -1) {
		switch (opt) {
		case 'p':
			strncpy(password, optarg, sizeof(password));
			askpass = 0;
			break;
		case 'h':
			strncpy(hashtype, optarg, sizeof(hashtype));
			break;
		default:
			fprintf(stderr, "Invalid arguments\n");
			usage();
			exit(1);
		}
	}
	if ((hash = hash_create(hashtype)) == NULL) {
		fprintf(stderr, "Unknown hash type: %s\n", hashtype);
		usage();
		exit(1);
	}
	if (optind >= argc) {
		fprintf(stderr, "No files found on the commandline\n");
		usage();
		exit(1);
	}
	if (askpass) {
		printf("Enter initial password: ");
		fgets(password, sizeof(password), stdin);
		chomp(password);
	}
	for (i = optind; i < argc; i++) {
		hash_getsalt(salt, sizeof(salt));
		snprintf(buf, sizeof(buf), "%s.salt", argv[i]);
		fd = fopen(buf, "w+");
		if (fd) {
			fwrite(salt, sizeof(salt), 1, fd);
			fclose(fd);
			hash_init(hash);
			hash_update(hash, salt, sizeof(salt));
			hash_update(hash, password, strlen(password));
			hash_finalize(hash, digest);
			snprintf(buf, sizeof(buf), "%s.H0", argv[i]);
			fd = fopen(buf, "w+");
			if (fd) {
				lcnt = 0;
				fwrite(&lcnt, sizeof(lcnt), 1, fd);
				fwrite(digest, sizeof(digest), 1, fd);
				fclose(fd);
			}
		}
	}
	return 0;
}
