/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __HASH_H
#define __HASH_H

#include "config.h"

#include <sys/uio.h>

#define	HASH_NONE	0
#define	HASH_DEFAULT	HASH_NONE
#define	HASH_SHA_1	1

#define MAX_DIGEST_STR	43	/* hexencoded + crlf + #0 */
#define MAX_DIGEST_LEN	20
#define MAX_HASH_EXT	10
#define MAX_HASH_NAME	8

typedef	struct	htable	{
	char *ht_name;
	char *ht_ext;
	int ht_type;
} htable_t;

typedef void *hash_context_t;

/* 
 * this structure describes a hash algorithm
 */
typedef	struct	hashtype {
	char	ht_name[MAX_HASH_NAME];
	char	ht_ext[MAX_HASH_EXT];
	int	ht_type;
	int	ht_diglen;
	hash_context_t (* ht_create) __P((void));
	void	(* ht_destroy) __P((hash_context_t));
	void	(* ht_init) __P((hash_context_t));
	void	(* ht_update) __P((hash_context_t, char *, int));
	void	(* ht_final) __P((hash_context_t, char *));
} hashtype_t;

typedef struct hashalgo {
	hashtype_t 	*ha_type;
	hash_context_t 	ha_ctx;
} hashalgo_t;

extern	hashtype_t 	*hash_find	__P((char *));

extern	hashalgo_t 	*hash_create	__P((char *));
extern	void		hash_destroy	__P((hashalgo_t *));
extern	void 		hash_init	__P((hashalgo_t *));
extern	void		hash_update	__P((hashalgo_t *, char *, size_t));
extern	void		hash_finalize	__P((hashalgo_t *, char *));

extern	void		hash_getsalt	__P((char *, size_t));

#define hash_getdigestlen(ha) ha->ha_type->ht_diglen

#endif
