%{
/*
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 *
 * $Id: lex.l,v 1.6 1998/10/29 11:27:28 bazsi Exp $
 */
#include "config.h"
#include "var.h"
#include "y.tab.h"

#include <string.h>

#if !defined(lint)
static const char rcsid[] = "$Id: lex.l,v 1.6 1998/10/29 11:27:28 bazsi Exp $";
#endif


extern int opts, yydebug;

int lineNum = 0, next = -1, state = 0, token = 0;

int	next_state __P((int, int));
int	next_item __P((int));
int	save_token __P((int));
void	swallow __P((void));
int	yylex __P((void));

struct	wordtab	{
	char	*word;
	int	state;
	int	next;
};

struct	wordtab	words[] = {
	{ "source",	IL_SOURCE,		IL_SRCNAME },
	{ "file",	IL_FILE,		IL_TOKEN },
	{ "unix-dgram",	IL_UNIX_DGRAM,		IL_TOKEN },
	{ "unix-stream",IL_UNIX_STREAM,		IL_TOKEN },
	{ "udp",	IL_UDP,			IL_TOKEN },
	{ "sun-stream", IL_SUN_STREAM,		IL_TOKEN },
	{ "sun-door",	IL_SUN_DOOR,		IL_TOKEN },

	{ "filter",	IL_FILTER,		IL_FILNAME },
	{ "facility",	IL_FACILITY,		IL_TOKEN },
	{ "priority",	IL_PRIORITY,		IL_TOKEN },
	{ "facpri",	IL_FACPRI,		IL_TOKEN },
	{ "netmask",	IL_NETMASK,		IL_TOKEN },
	{ "match",	IL_MATCH,		IL_TOKEN },
	{ "match-file",	IL_MATCHFILE,		IL_TOKEN },
	{ "match-prog",	IL_MATCHPROG,		IL_TOKEN },

	{ "destination",IL_DESTINATION,		IL_DESTNAME },
	{ "tcp",	IL_TCP,			IL_TOKEN },
	{ "user",	IL_USER,		IL_TOKEN },
	{ "sync",	IL_SYNC,		IL_TOKEN },
	{ "raw",	IL_RAW,			-1 },
	{ "hashed",	IL_HASHED,		-1 },
	{ "options",	IL_OPTIONS,		-1 },
	{ "mark",	IL_MARK,		IL_TOKEN },
	{ "hash",	IL_HASH,		-1 },
	{ "logdir",	IL_LOGDIR,		IL_TOKEN },
	{ "dir",	IL_DIRECTORY,		IL_TOKEN },
	{ "directory",	IL_DIRECTORY,		IL_TOKEN },
	{ "algorithm",	IL_HASHALGO,		IL_TOKEN },
	{ "chroot",	IL_CHROOT,		IL_TOKEN },

	{ "not",	IL_NOT,			-1 },
	{ "!",		IL_NOT,			-1 },
	{ "log",	IL_LOG,			-1 },
	{ "=",		IL_EQ,			-1 },
	{ "!=",		IL_NEQ,			-1 },
	{ "<",		IL_LT,			-1 },
	{ ">",		IL_GT,			-1 },
	{ ">=",		IL_GE,			-1 },
	{ "<=",		IL_LE,			-1 },
	{ "\377",	-1,			0 },
	{ NULL, 0, 0 }
};
%}
white	[ \t\r]+
%%
{white}	;
\n	{ lineNum++; swallow(); }
\{	{ return next_state('{', -1); }
\}	{ return next_state('}', -1); }
\|	{ return next_state('|', -1); }
\;	{ return next_state(';', -1); }
\,	{ return next_state(',', -1); }
#[^\n]*	{ return IL_COMMENT; }
[^ \{\}\n\t\;|,]*	{ return next_item(IL_TOKEN); }
\"[^\"]*\"	{ return next_item(IL_TOKEN); }
%%
int
save_token(type)
	int type;
{
	int	i;

	if (yydebug)
		printf("save_token(%d) [%s]\n", type, yytext);
	yylval.str = strdup(yytext);
	if ((type == IL_SRCNAME) || (type == IL_FILNAME) ||
	    (type == IL_DESTNAME)) {
		if ((i = new_var(yylval.str, type)) != 0)
			return i;
	}
	return type;
}


int
next_item(nstate)
	int nstate;
{
	struct	wordtab	*wt;
	var_t	*v;
	int	i;

	if (yydebug)
		printf("text=[%s] id=%d next=%d\n", yytext, nstate, next);

	if (next == IL_TOKEN) {
		next = -1;
		token++;
		return save_token(IL_TOKEN);
	}

	for (wt = words; wt->word; wt++)
		if (!strcasecmp(wt->word, yytext)) {
			token++;
			return next_state(wt->state, wt->next);
		}

	if (next == IL_SRCNAME || next == IL_FILNAME || next == IL_DESTNAME) {
		nstate = next;
		next = -1;
		i = save_token(nstate);
		if (i == IL_SRCNAME || i == IL_FILNAME || i == IL_DESTNAME)
			token++;
		return i;
	}

	if ((nstate == IL_TOKEN) && (v = get_var(yytext))) {
		yylval.str = yytext;
		token++;
		return v->v_type;
	}

	if (yydebug)
		printf("unknown keyword=[%s]\n", yytext);

	next = -1;
	return save_token(IL_TOKEN);
}


int
next_state(nstate, fornext)
	int nstate, fornext;
{
	next = fornext;
	if (yydebug)
		printf("next_state(nstate=%d,fornext=%d)\n", nstate, fornext);
	return nstate;
}


void
swallow()
{
	int c = input();

	if (c == '#') {
		while ((c != '\n') && (c != EOF))
			c = input();
	}
	unput(c);
}
