/***************************************************************************
 *
 * Copyright (c) 1998 BalaBit Computing
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __VAR_H
#define __VAR_H

#include "config.h"

#include <stdlib.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/un.h>
#include <netinet/in.h>

#ifdef USE_POSIX_REGEX
#include <regex.h>
#else
#include <regexp.h>
#endif

#include "syslog-ng.h"

#include "cfgdefs.h"
#include "filters.h"
#include "affile.h"
#include "afunix.h"
#include "afinet.h"
#include "afuser.h"
#include "afpipe.h"
#include "afstreams.h"
#include "afdoor.h"
#include "filters.h"

#define	REGCOMP_FLAGS	(REG_EXTENDED|REG_ICASE|REG_NOSUB)

/* extern	int		token; */

extern	var_t		*get_var __P((char *));
extern	int		new_var __P((char *, int));
extern	var_t		*new_anon __P((int));
extern	void		new_obj __P((char *));
extern	var_t 		*add_obj __P((int, void *));
extern	var_t		*end_obj __P((void));
extern	void		end_file __P((void));

extern	matchspec_t	*new_match __P((char *));
extern	matchspec_t	*match_find __P((char *));

extern	matchfilespec_t	*new_matchfile __P((char *));
extern	matchfilespec_t	*matchfile_find __P((char *));

extern	matchprogspec_t	*new_matchprog __P((char *));
extern	matchprogspec_t	*matchprog_find __P((char *));

extern	unixspec_t	*new_unix __P((int, int, char *));
extern	unixspec_t	*unix_find __P((int, int, char *));

extern	userspec_t	*new_user __P((char *));
extern	userspec_t	*user_find __P((char *));

extern	streamspec_t *	sunstream_find __P((int, char *));
extern	streamspec_t *	new_sunstream __P((int, char *));

extern	doorspec_t	*sundoor_find __P((int, char *));
extern	doorspec_t 	*new_sundoor __P((int, char *));

extern	filespec_t	*new_file __P((int, char *));
extern	filespec_t	*file_find __P((int, char *));

extern	netspec_t	*new_net __P((int, int, char *, char *));
extern	netspec_t	*net_find __P((int, int, struct in_addr, u_short));

extern	nmaskspec_t	*new_nmask __P((char *));
extern	nmaskspec_t	*nmask_find __P((char *));

extern	cmdspec_t	*new_cmd __P((char *));

extern	facprispec_t	*new_facprival __P((int, int));

extern	facspec_t	*new_fac __P((char *));
extern	facspec_t	*fac_find __P((int));

extern	prispec_t	*new_pri __P((int, char *));
extern	prispec_t	*pri_find __P((int, int));

extern	facprispec_t	*new_facpri __P((char *, int, char *));
extern	facprispec_t	*facpri_find __P((int));

extern	facspec_t	*new_facval __P((int));
extern	prispec_t	*new_prival __P((int, int));

extern	int		find_facname __P((char *));
extern	int		find_priname __P((char *));
extern	char		*fac_toname __P((int));
extern	char		*pri_toname __P((int));

extern	cmdspec_t	*cmd_find __P((char *));

extern	void		link_sfd __P((var_t *, fillist_t *, var_t *));
extern	fillist_t	*link_filters __P((char *, fillist_t *));
extern	fillist_t	*add_filter __P((fillist_t *, fillist_t *));

extern	void		regerr __P((int));

extern	void		set_sync __P((int));
extern	void		set_mark __P((int));
extern	void		set_raw __P((void));
extern	void		set_hashed __P((void));
extern	void		set_option __P((int, char *));
extern 	void		set_hoption __P((int, char *));
extern	void		set_not __P((int));
extern	int		get_not __P((void));

extern	void		expire_all __P((void));
extern	void		expire_old __P((void));

extern	void		setup_filetable __P((void));
extern	void		sync_all __P((void));

extern	filetype_t	 *new_filetype __P((int));
extern	void		free_type __P((filetype_t *));
extern	void		print_type __P((filetype_t *ft));

extern	void		free_filter __P((fillist_t *));
extern	void		free_var __P((var_t *));

extern	void		dump_all __P((void));
extern	void		print_not __P((int));

extern	int		next_dfd __P((void **, int *));
extern	int		next_sfd __P((void **, int *));

#endif
