%{
/*
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 *
 * $Id: yac.y,v 1.11 1998/11/17 19:05:35 bazsi Exp $
 */
#include "config.h"
#include "var.h"

#include <stdio.h>

#define YYERROR_VERBOSE 1

#if !defined(lint)
static const char rcsid[] = "$Id: yac.y,v 1.11 1998/11/17 19:05:35 bazsi Exp $";
#endif

extern	int	opts;
extern	int	state, state, lineNum, token;
extern	int	yylineno;
extern	char	*yytext;
extern	FILE	*yyin;

void	yyerror	__P((char *));
int	yylex	__P((void));
#define	YYDEBUG 1
#if !defined(ultrix) && !defined(hpux)
int	yydebug = 0;
#else
extern	int	yydebug;
#endif

int	yyparse __P((void));
%}
%union {
	void	*var;
	char	*str;
	int	num;
	void	*mspec;
	void	*nspec;
	void	*fspec;
	void	*uspec;
	void	*xspec;
	void	*sspec;
	void	*dspec;
	void	*cspec;
	void	*nmask;
	void	*fac;
	void	*pri;
	void	*facpri;
	void	*rot;
}
%type	<mspec>	regex regfile matchprog
%type	<nspec> sinet dinet
%type	<fspec>	ofile dfile sfile
%type	<uspec> user
%type	<xspec>	sunix dunix
%type	<sspec> sunstream
%type	<dspec> sundoor
%type	<num> sync
%type	<cspec> command
%type	<nmask> wrapper
%type	<fac> facility
%type	<pri> priority pri
%type	<facpri> facpri
%type	<var> dest destlist destobj src srclist srcobj fil mfil fillist filobj
%type	<var> actsrc actdest actfil dofilter filnamelist
%type	<str> filname
%type	<num> compare
%token	<str> IL_TOKEN
%token	<str> IL_DESTNAME IL_SRCNAME IL_FILNAME
%token	IL_SOURCE IL_FILE IL_UNIX_DGRAM IL_UNIX_STREAM IL_USER IL_TCP IL_UDP IL_FILTER IL_FACILITY
%token	IL_PRIORITY IL_FACPRI IL_MATCH IL_MATCHFILE IL_MATCHPROG
%token	IL_DESTINATION IL_RAW IL_HASHED IL_SUN_STREAM IL_SUN_DOOR
%token	IL_LOG IL_NOT
%token	<num> IL_LT IL_LE IL_GT IL_GE IL_NEQ IL_EQ
%token	IL_COMMENT IL_OUTPUT IL_NETMASK
%token	IL_OPTIONS IL_MARK IL_SYNC IL_HASH IL_DIRECTORY IL_HASHALGO IL_LOGDIR
%token	IL_CHROOT
%%
file:	line ';'
	| line ';' file
	| IL_COMMENT
	| IL_COMMENT file
	;

line:	options
	| source
	| filter
	| destination
	| action
	| ';'
	;

options:
	IL_OPTIONS '{' optlist '}'
	;

optlist:
	option
	| option optlist
	;

option:	syncopt ';'
	| markopt ';'
	| hash ';'
	| diropt ';'
	| logdiropt ';'
/*	| chroot ';' */
	;

markopt:
	IL_MARK IL_TOKEN		{ set_option(IL_MARK, $2); free($2); }
	;

syncopt:
	IL_SYNC IL_TOKEN		{ set_option(IL_SYNC, $2); free($2); }
	;

diropt:	IL_DIRECTORY IL_TOKEN		{ set_option(IL_DIRECTORY, $2); }
	;

logdiropt:
	IL_LOGDIR IL_TOKEN		{ set_option(IL_LOGDIR, $2); }
	;

/*
chroot:	IL_CHROOT IL_TOKEN		{ set_option(IL_CHROOT, $2); }
	;
*/

hash:	IL_HASH '{' hashlist '}'
	;

hashlist:
	hashopt
	| hashopt hashlist
	;

hashopt:
	hashdir ';'
	| algo ';'
	;

hashdir:
	IL_DIRECTORY IL_TOKEN		{ set_hoption(IL_DIRECTORY, $2); }
	;

algo:	IL_HASHALGO IL_TOKEN		{ set_hoption(IL_HASHALGO, $2);
					  free($2);}
	;

source:	newsrc srcobj
	;

newsrc:	IL_SOURCE IL_SRCNAME		{ new_obj($2); free($2); }
	;

srcobj:	'{' srclist '}'			{ $$ = $2; end_obj(); }
	;

srclist:
	src				{ $$ = $1; }
	| src srclist			{ $$ = $1; }
	;

src:	sfile ';'			{ $$ = add_obj(SRC_FILE, $1); }
	| sunix ';'			{ $$ = add_obj(SRC_UNIX, $1); }
	| sinet ';'			{ $$ = add_obj(SRC_INET, $1); }
	| sunstream ';'			{ $$ = add_obj(SRC_SUN_STREAM, $1); }
	| sundoor ';'			{ $$ = add_obj(SRC_SUN_DOOR, $1); }
	;

sfile:	IL_FILE IL_TOKEN		{ $$ = new_file(SRC_FILE, $2);
					  free($2); }
	;

sunix:	IL_UNIX_DGRAM IL_TOKEN		{ $$ = new_unix(SRC_UNIX, NET_UNIX_DGRAM, $2);
					  free($2); }
	| IL_UNIX_STREAM IL_TOKEN	{ $$ = new_unix(SRC_UNIX, NET_UNIX_STREAM, $2);
					  free($2); }
	;

sinet:	IL_UDP IL_TOKEN ',' IL_TOKEN	{ $$ = new_net(SRC_INET, NET_UDP,
						       $2, $4);
					  free($2); free($4); }
	| IL_TCP IL_TOKEN ',' IL_TOKEN	{ $$ = new_net(SRC_INET, NET_TCP,
						       $2, $4); }
	;

sunstream:	IL_SUN_STREAM IL_TOKEN	{ $$ = new_sunstream(SRC_SUN_STREAM, $2); 
					  free($2); }
	;

sundoor:	IL_SUN_DOOR IL_TOKEN	{ $$ = new_sundoor(SRC_SUN_DOOR, $2);
					  free($2); }

filter:	newfil filobj
	;

newfil:	IL_FILTER IL_FILNAME		{ new_obj($2); free($2); }
	;

filobj:	'{' fillist '}' 		{ $$ = $2; end_obj(); }
	;

fillist:
	mfil				{ $$ = $1; }
	| mfil fillist			{ $$ = $1; }
	;

mfil:	fil				{ $$ = $1; }
	| not fil			{ $$ = $2; }
	;

not:	IL_NOT				{ set_not(1); }
	;

fil:	facility ';'			{ $$ = add_obj(FIL_FAC, $1); }
	| priority ';'			{ $$ = add_obj(FIL_PRI, $1); }
	| facpri ';'			{ $$ = add_obj(FIL_FACPRI,$1);}
	| regex ';'			{ $$ = add_obj(FIL_MATCH, $1);}
	| regfile ';'			{ $$ = add_obj(FIL_MATCHFILE, $1);}
	| matchprog ';'			{ $$ = add_obj(FIL_MATCHPROG, $1);}
/*	| command ';'			{ $$ = add_obj(FIL_CMD, $1); } */
	| wrapper ';'			{ $$ = add_obj(FIL_WRAP, $1); }
	;

facility:
	IL_FACILITY IL_TOKEN		{ $$ = new_fac($2); free($2); }
	;

priority:
	IL_PRIORITY pri 			{ $$ = $2; }
	;

facpri:	IL_FACPRI IL_TOKEN ',' IL_TOKEN { $$ = new_facpri($2, IL_GE, $4);
					  free($2); free($4); }
	| IL_FACPRI IL_TOKEN ',' compare IL_TOKEN
					{ $$ = new_facpri($2, $4, $5);
					  free($2); free($5); }
	;

pri:	IL_TOKEN			{ $$ = new_pri(IL_GE, $1); free($1); }
	| compare IL_TOKEN		{ $$ = new_pri($1, $2); free($2); }
	;

compare:
	IL_EQ				{ $$ = $1; }
	| IL_NEQ			{ $$ = $1; }
	| IL_LT				{ $$ = $1; }
	| IL_LE				{ $$ = $1; }
	| IL_GT				{ $$ = $1; }
	| IL_GE				{ $$ = $1; }
	;

regex:	IL_MATCH IL_TOKEN 		{ $$ = new_match($2); free($2); }
	;

regfile:
	IL_MATCHFILE IL_TOKEN 		{ $$ = new_matchfile($2); free($2); }
	;

matchprog:
	IL_MATCHPROG IL_TOKEN		{ $$ = new_matchprog($2); free($2); }
	;

wrapper:
	IL_NETMASK IL_TOKEN 		{ $$ = new_nmask($2); free($2); }
	;

command:
	'|' IL_TOKEN			{ $$ = new_cmd($2); free($2); }
	;

destination:
	newdest destobj
	;

newdest:
	IL_DESTINATION IL_DESTNAME	{ new_obj($2); free($2); }
	;

destobj:
	'{' destlist '}' 		{ $$ = $2; end_obj(); }
	;

destlist:
	dest				{ $$ = $1; }
	| dest destlist			{ $$ = $1; }
	;

dest:	hashed dfile ';'		{ $$ = add_obj(DEST_FILE, $2);
					  end_file(); }
	| raw dinet ';'			{ $$ = add_obj(DEST_INET, $2); }
	| raw dunix ';'			{ $$ = add_obj(DEST_UNIX, $2); }
	| command ';'			{ $$ = add_obj(DEST_CMD, $1); }
	| user ';'			{ $$ = add_obj(DEST_USER, $1); }
	;

hashed:	|
	IL_HASHED			{ set_hashed(); }
	;

raw:	|
	IL_RAW				{ set_raw(); }
	;

dfile:	ofile
	| ofile sync 			{ set_sync($2); }
	;

ofile:	IL_FILE IL_TOKEN		{ $$ = new_file(DEST_FILE, $2);
					  free($2); }
	;

dunix:	IL_UNIX_DGRAM IL_TOKEN		{ $$ = new_unix(DEST_UNIX, NET_UNIX_DGRAM, $2);
					  free($2); }
	| IL_UNIX_STREAM IL_TOKEN	{ $$ = new_unix(DEST_UNIX, NET_UNIX_STREAM, $2);
					  free($2); }
	;

user:	IL_USER IL_TOKEN		{ $$ = new_user($2); free($2); }
	;

dinet:	IL_TCP IL_TOKEN ',' IL_TOKEN	{ $$ = new_net(DEST_INET, NET_TCP,
						       $2, $4);
					  free($2); free($4); }
	| IL_UDP IL_TOKEN ',' IL_TOKEN	{ $$ = new_net(DEST_INET, NET_UDP,
						       $2, $4);
					  free($2); free($4); }
	;

sync:	IL_SYNC IL_TOKEN		{ $$ = strtol($2, NULL, 0); free($2); }
	;

action:	IL_LOG '{' logrule '}'
	;

logrule:
	actsrc ';' actdest ';' 			{ link_sfd($1, NULL, $3); }
	| actsrc ';' dofilter actdest ';'	{ link_sfd($1, $3, $4); }
	;

actsrc:	IL_SOURCE IL_SRCNAME			{ $$ = get_var($2); free($2); }
	| srcobj				{ $$ = $1; }
	;

actdest:
	IL_DESTINATION IL_DESTNAME 		{ $$ = get_var($2); free($2); }
	| destobj 				{ $$ = $1; }
	;

dofilter:
	actfil ';'				{ $$ = add_filter($1, NULL);}
	| dofilter ';' actfil			{ $$ = add_filter($1, $3); }
	;

actfil:	IL_FILTER filnamelist			{ $$ = $2; }
	;

filnamelist:
	filname					{ $$ = link_filters($1, NULL);
						  free($1); }
	| filname ',' filnamelist		{ $$ = link_filters($1, $3);
						  free($1); }
	;

filname:
	IL_FILNAME				{ $$ = $1; }
	| not IL_FILNAME			{ $$ = $2; }
	;
%%

void
yyerror(msg)
	char	*msg;
{
	if (opts & (OPT_DEBUG|OPT_VERBOSE))
		fprintf(stderr, "%s at \"%s\", line %d\n", msg, yytext,
			lineNum + 1);
}
