/***************************************************************************
 *
 * Copyright (c) 1999 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Inspired by nsyslog, originally written by Darren Reed.
 *
 * $Id: affile.h,v 1.5 1999/06/08 19:47:31 bazsi Exp $
 *
 ***************************************************************************/

#ifndef __AFFILE_H
#define __AFFILE_H

#include "syslog-ng.h"

#include "log.h"
#include "io.h"
#include "sources.h"
#include "destinations.h"

#define CLASS_DECLARE
#include "affile.h.x"
#undef CLASS_DECLARE

/* CLASS:
     (class
       (name affile_dest)
       (super log_dest_driver)
       (vars
         (name string)
         (flags simple int)
	 ;(attempts simple int)
         (dest object io_fd)
	 (sync_freq simple UINT32)))
*/

struct log_source_driver *make_affile_source(const char *name);

struct affile_dest *make_affile_dest(const char *name, int flags);

#endif
