#ifndef CLASS_DEFINE
struct syslog_conf
{
  struct ol_object super;
  int (*(init))(struct syslog_conf *self);
  int (*(destroy))(struct syslog_conf *self);
  struct resource_list *resources;
  struct io_backend *backend;
  UINT32 long_hostnames;
  UINT32 mark_freq;
  UINT32 sync_freq;
  struct log_handler *internal;
  struct log_source_group *sources;
  struct log_filter *filters;
  struct log_dest_group *destinations;
  struct log_connection *connections;
};
extern struct ol_class syslog_conf_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_syslog_conf_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct syslog_conf *i = (struct syslog_conf *) o;
  mark((struct ol_object *) i->resources);
  mark((struct ol_object *) i->backend);
  mark((struct ol_object *) i->internal);
  mark((struct ol_object *) i->sources);
  mark((struct ol_object *) i->filters);
  mark((struct ol_object *) i->destinations);
  mark((struct ol_object *) i->connections);
}

struct ol_class syslog_conf_class =
{ STATIC_HEADER,
  0, "syslog_conf", sizeof(struct syslog_conf),
  do_syslog_conf_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

