#ifndef CLASS_DEFINE
struct affile_dest
{
  struct log_dest_driver super;
  struct ol_string *name;
  int flags;
  struct io_fd *dest;
  UINT32 sync_freq;
};
extern struct ol_class affile_dest_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_affile_dest_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct affile_dest *i = (struct affile_dest *) o;
  mark((struct ol_object *) i->dest);
}

static void do_affile_dest_free(struct ol_object *o)
{
  struct affile_dest *i = (struct affile_dest *) o;
  ol_string_free(i->name);
}

struct ol_class affile_dest_class =
{ STATIC_HEADER,
  &log_dest_driver_class, "affile_dest", sizeof(struct affile_dest),
  do_affile_dest_mark,
  do_affile_dest_free
};
#endif /* !CLASS_DECLARE */

