#ifndef CLASS_DEFINE
struct afsocket_source_close_callback
{
  struct close_callback super;
  struct resource_node * res;
  struct syslog_conf *cfg;
};
extern struct ol_class afsocket_source_close_callback_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afsocket_source_close_callback_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct afsocket_source_close_callback *i = (struct afsocket_source_close_callback *) o;
  mark((struct ol_object *) i->cfg);
}

struct ol_class afsocket_source_close_callback_class =
{ STATIC_HEADER,
  &close_callback_class, "afsocket_source_close_callback", sizeof(struct afsocket_source_close_callback),
  do_afsocket_source_close_callback_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct afsocket_source_connection
{
  struct log_handler_pipe super;
  int fd;
  struct io_fd *src;
};
extern struct ol_class afsocket_source_connection_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afsocket_source_connection_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct afsocket_source_connection *i = (struct afsocket_source_connection *) o;
  mark((struct ol_object *) i->src);
}

struct ol_class afsocket_source_connection_class =
{ STATIC_HEADER,
  &log_handler_pipe_class, "afsocket_source_connection", sizeof(struct afsocket_source_connection),
  do_afsocket_source_connection_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct afsocket_accept_callback
{
  struct fd_listen_callback super;
  struct syslog_conf *cfg;
  struct io_backend *backend;
  struct log_handler *next;
};
extern struct ol_class afsocket_accept_callback_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afsocket_accept_callback_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct afsocket_accept_callback *i = (struct afsocket_accept_callback *) o;
  mark((struct ol_object *) i->cfg);
  mark((struct ol_object *) i->backend);
  mark((struct ol_object *) i->next);
}

struct ol_class afsocket_accept_callback_class =
{ STATIC_HEADER,
  &fd_listen_callback_class, "afsocket_accept_callback", sizeof(struct afsocket_accept_callback),
  do_afsocket_accept_callback_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct afsocket_source
{
  struct log_source_driver super;
  UINT32 flags;
  struct socket_addr *sa;
};
extern struct ol_class afsocket_source_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afsocket_source_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct afsocket_source *i = (struct afsocket_source *) o;
  mark((struct ol_object *) i->sa);
}

struct ol_class afsocket_source_class =
{ STATIC_HEADER,
  &log_source_driver_class, "afsocket_source", sizeof(struct afsocket_source),
  do_afsocket_source_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct afsocket_dest
{
  struct log_dest_driver super;
  struct io_fd *dest;
  struct resource_node * dest_res;
  struct socket_addr *sa;
  UINT32 flags;
};
extern struct ol_class afsocket_dest_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afsocket_dest_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct afsocket_dest *i = (struct afsocket_dest *) o;
  mark((struct ol_object *) i->dest);
  mark((struct ol_object *) i->sa);
}

struct ol_class afsocket_dest_class =
{ STATIC_HEADER,
  &log_dest_driver_class, "afsocket_dest", sizeof(struct afsocket_dest),
  do_afsocket_dest_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

