/***************************************************************************
 *
 * Copyright (c) 1999 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Inspired by nsyslog, originally written by Darren Reed.
 *
 * $Id: afsocket.h,v 1.6 1999/06/08 19:47:31 bazsi Exp $
 *
 ***************************************************************************/

#ifndef __AFUNIX_H_INCLUDED
#define __AFUNIX_H_INCLUDED

#include "syslog-ng.h"
#include "io.h"
#include "sources.h"

#define AFSOCKET_STREAM		0x0000
#define AFSOCKET_DGRAM		0x0001
#define AFSOCKET_INET		0x0000
#define AFSOCKET_UNIX		0x0002

#define AFINET_PROTO_STREAM	(AFSOCKET_STREAM | AFSOCKET_INET)
#define AFINET_PROTO_DGRAM	(AFSOCKET_DGRAM | AFSOCKET_INET)
#define AFUNIX_PROTO_STREAM	(AFSOCKET_STREAM | AFSOCKET_UNIX)
#define AFUNIX_PROTO_DGRAM	(AFSOCKET_DGRAM | AFSOCKET_UNIX)

#define AFSOCKET_TYPE		0x0001
#define AFSOCKET_PROTO          0x0002

#define CLASS_DECLARE
#include "afsocket.h.x"
#undef CLASS_DECLARE

/* CLASS:
   (class
     (name socket_addr)
     (vars
       (bind method int "int fd")
       (connect method int "int fd")
       (sa special "struct sockaddr *" #f free_sockaddr)
       (salen simple int)))
*/

#define BIND_SOCKET(a, f) ((a)->bind(a, f))
#define CONNECT_SOCKET(a, f) ((a)->connect(a, f))

struct socket_addr *make_unix_addr(const char *name);
struct socket_addr *make_inet_addr(struct in_addr host, unsigned short port);

struct log_source_driver *make_afsocket_source(struct socket_addr *sa, UINT32 flags);
struct log_dest_driver *make_afsocket_dest(struct socket_addr *sa, UINT32 flags);


#endif

