#ifndef CLASS_DEFINE
struct socket_addr
{
  struct ol_object super;
  int (*(bind))(struct socket_addr *self, int fd);
  int (*(connect))(struct socket_addr *self, int fd);
  struct sockaddr * sa;
  int salen;
};
extern struct ol_class socket_addr_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_socket_addr_free(struct ol_object *o)
{
  struct socket_addr *i = (struct socket_addr *) o;
  free_sockaddr(i->sa);
}

struct ol_class socket_addr_class =
{ STATIC_HEADER,
  0, "socket_addr", sizeof(struct socket_addr),
  NULL,
  do_socket_addr_free
};
#endif /* !CLASS_DECLARE */

