#ifndef CLASS_DEFINE
struct afsocket_params
{
  struct ol_object super;
  int (*(init))(struct afsocket_params *self, struct log_handler *c, struct syslog_conf *cfg);
};
extern struct ol_class afsocket_params_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct ol_class afsocket_params_class =
{ STATIC_HEADER,
  0, "afsocket_params", sizeof(struct afsocket_params),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct afsocket_source_close_callback
{
  struct close_callback super;
  struct resource_node * res;
  struct syslog_conf *cfg;
};
extern struct ol_class afsocket_source_close_callback_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afsocket_source_close_callback_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct afsocket_source_close_callback *i = (struct afsocket_source_close_callback *) o;
  mark((struct ol_object *) i->cfg);
}

struct ol_class afsocket_source_close_callback_class =
{ STATIC_HEADER,
  &close_callback_class, "afsocket_source_close_callback", sizeof(struct afsocket_source_close_callback),
  do_afsocket_source_close_callback_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct afsocket_source_connection
{
  struct log_handler_pipe super;
  int fd;
  struct io_fd *src;
};
extern struct ol_class afsocket_source_connection_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afsocket_source_connection_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct afsocket_source_connection *i = (struct afsocket_source_connection *) o;
  mark((struct ol_object *) i->src);
}

struct ol_class afsocket_source_connection_class =
{ STATIC_HEADER,
  &log_handler_pipe_class, "afsocket_source_connection", sizeof(struct afsocket_source_connection),
  do_afsocket_source_connection_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct afsocket_accept_callback
{
  struct fd_listen_callback super;
  struct syslog_conf *cfg;
  struct io_backend *backend;
  struct log_handler *next;
};
extern struct ol_class afsocket_accept_callback_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afsocket_accept_callback_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct afsocket_accept_callback *i = (struct afsocket_accept_callback *) o;
  mark((struct ol_object *) i->cfg);
  mark((struct ol_object *) i->backend);
  mark((struct ol_object *) i->next);
}

struct ol_class afsocket_accept_callback_class =
{ STATIC_HEADER,
  &fd_listen_callback_class, "afsocket_accept_callback", sizeof(struct afsocket_accept_callback),
  do_afsocket_accept_callback_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct afunix_source_params
{
  struct afsocket_params super;
  struct ol_string *owner;
  struct ol_string *group;
  int perm;
};
extern struct ol_class afunix_source_params_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afunix_source_params_free(struct ol_object *o)
{
  struct afunix_source_params *i = (struct afunix_source_params *) o;
  ol_string_free(i->owner);
  ol_string_free(i->group);
}

struct ol_class afunix_source_params_class =
{ STATIC_HEADER,
  &afsocket_params_class, "afunix_source_params", sizeof(struct afunix_source_params),
  NULL,
  do_afunix_source_params_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct afsocket_source
{
  struct log_source_driver super;
  struct afsocket_params *params;
  UINT32 flags;
  struct address_info *src_addr;
};
extern struct ol_class afsocket_source_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afsocket_source_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct afsocket_source *i = (struct afsocket_source *) o;
  mark((struct ol_object *) i->params);
  mark((struct ol_object *) i->src_addr);
}

struct ol_class afsocket_source_class =
{ STATIC_HEADER,
  &log_source_driver_class, "afsocket_source", sizeof(struct afsocket_source),
  do_afsocket_source_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct afsocket_dest_connected
{
  struct fd_callback super;
  struct afsocket_dest *logger;
  struct syslog_conf *cfg;
};
extern struct ol_class afsocket_dest_connected_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afsocket_dest_connected_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct afsocket_dest_connected *i = (struct afsocket_dest_connected *) o;
  mark((struct ol_object *) i->logger);
  mark((struct ol_object *) i->cfg);
}

struct ol_class afsocket_dest_connected_class =
{ STATIC_HEADER,
  &fd_callback_class, "afsocket_dest_connected", sizeof(struct afsocket_dest_connected),
  do_afsocket_dest_connected_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct afsocket_dest
{
  struct log_dest_driver super;
  struct io_fd *dest;
  struct abstract_buffer *dest_buf;
  struct resource_node * dest_res;
  struct address_info *src_addr;
  struct address_info *dest_addr;
  UINT32 flags;
};
extern struct ol_class afsocket_dest_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afsocket_dest_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct afsocket_dest *i = (struct afsocket_dest *) o;
  mark((struct ol_object *) i->dest);
  mark((struct ol_object *) i->dest_buf);
  mark((struct ol_object *) i->src_addr);
  mark((struct ol_object *) i->dest_addr);
}

struct ol_class afsocket_dest_class =
{ STATIC_HEADER,
  &log_dest_driver_class, "afsocket_dest", sizeof(struct afsocket_dest),
  do_afsocket_dest_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

