#ifndef CLASS_DEFINE
struct stream_read
{
  struct abstract_read super;
  int fd;
};
extern struct ol_class stream_read_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct ol_class stream_read_class =
{ STATIC_HEADER,
  &abstract_read_class, "stream_read", sizeof(struct stream_read),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct afstreams_source
{
  struct log_source_driver super;
  struct ol_string *name;
  struct ol_string *door_name;
  struct io_fd *stream_fd;
  int door;
};
extern struct ol_class afstreams_source_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_afstreams_source_mark(struct ol_object *o, 
void (*mark)(struct ol_object *o))
{
  struct afstreams_source *i = (struct afstreams_source *) o;
  mark((struct ol_object *) i->stream_fd);
}

static void do_afstreams_source_free(struct ol_object *o)
{
  struct afstreams_source *i = (struct afstreams_source *) o;
  ol_string_free(i->name);
  ol_string_free(i->door_name);
}

struct ol_class afstreams_source_class =
{ STATIC_HEADER,
  &log_source_driver_class, "afstreams_source", sizeof(struct afstreams_source),
  do_afstreams_source_mark,
  do_afstreams_source_free
};
#endif /* !CLASS_DECLARE */

