/***************************************************************************
 *
 * Copyright (c) 1999 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Inspired by nsyslog, originally written by Darren Reed.
 *
 * $Id: afinter.c,v 1.7 1999/07/18 12:56:11 bazsi Exp $
 *
 * Log source for internal messages of syslog-ng
 *
 ***************************************************************************/

#include "afinter.h"
#include "werror.h"
#include "syslog-names.h"
#include "cfgfile.h"
#include "log.h"

static struct syslog_conf *assigned_configuration = NULL;

static int write_internal_message(int level, UINT32 length, UINT8 *data)
{
	struct log_info *msg;
	int pri;

	if (assigned_configuration && assigned_configuration->internal) {
		switch (level) {
		case MSG_DEBUG:
		case MSG_VERBOSE:
		case MSG_NOTICE:
		case MSG_ERROR:
		case MSG_FATAL:
		default:
			pri = LOG_SYSLOG | LOG_NOTICE;
		}
		while (data[length - 1] == '\n') 
			length--;
		msg = make_internal_message(pri, length, data);
		msg->flags |= LF_LOCAL;
		HANDLE_LOG(assigned_configuration->internal, msg);
		return 0;
	}
	return 0;
}

void set_error_internal(void)
{
	error_write = write_internal_message;
}

static int do_init_afinter(struct log_handler *c, struct syslog_conf *cfg)
{
	CAST(log_source_driver, self, c);
	if (assigned_configuration == NULL) {
		cfg->internal = self->super.next;
		assigned_configuration = cfg;
		return ST_OK | ST_GOON;
	}
	else {
		werror("Internal sources can only be referenced once!\n");
		return ST_FAIL | ST_QUIT;
	}
}

static int do_destroy_afinter(struct log_handler *c, struct syslog_conf *cfg)
{
	if (cfg == assigned_configuration)
		assigned_configuration = NULL;
	return 0;
}

struct log_source_driver *make_afinter_source(void)
{
	NEW(log_source_driver, self);

	self->super.super.init = do_init_afinter;
	self->super.super.destroy = do_destroy_afinter;
	return self;
}
