/***************************************************************************
 *
 * Copyright (c) 1999 Balzs Scheidler
 * Copyright (c) 1999 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Inspired by nsyslog, originally written by Darren Reed.
 *
 * $Id: center.c,v 1.12 1999/11/20 19:13:39 bazsi Exp $
 *
 ***************************************************************************/

#include "center.h"
#include "format.h"
#include "filters.h"

#include <assert.h>

#define CLASS_DEFINE
#include "center.h.x"
#undef CLASS_DEFINE

#include "center.c.x"

/* log_endpoint_info */

struct log_endpoint_info *make_log_endpoint_info(int type, const char *name)
{
	NEW(log_endpoint_info, self);
	
	self->type = type;
	self->name = c_format("%z", name);
	return self;
}

/* log_connection */

struct log_connection *make_log_connection(struct log_endpoint_info *nodes)
{
	NEW(log_connection, self);
	
	self->nodes = nodes;
	return self;
}


/* CLASS:
     (class
       (name log_center)
       (super log_handler)
       (vars
         (connections object log_connection)))
*/

/* FIXME: make the below algorithm a bit quicker */
static void do_distribute_log(struct log_handler *c, struct log_info *msg)
{
	CAST(log_center, self, c);
	struct log_connection *p, *def_connection = NULL;
	int match = 0;
	
	for (p = self->connections; p; p = p->next) {
		struct log_endpoint_info *s;

		if (p->flags & LOG_CONN_DEFAULT) {
			def_connection = p;
			continue;
		}
		for (s = p->nodes; s; s = s->next) {
			if ((s->type == EP_SOURCE) && ((struct ol_object *) msg->source == s->ref)) {
				/* 
				 * so we found this source in a log statement,
				 * distribute message
				 */
				struct log_endpoint_info *f, *d;

				for (f = p->nodes; f; f = f->next) {
					if (f->type == EP_FILTER && 
					    !FILTER_RULE_EVAL(((struct log_filter *) f->ref)->root, (struct log_filter *) f->ref, msg))
						goto next_connection;

				}
				for (d = p->nodes; d; d = d->next) {
					match = 1;
					if (d->type == EP_DESTINATION) {
						assert(d->ref);
						HANDLE_LOG(d->ref, log_info_use(msg));
					}
				}
			}
		}
		
	next_connection:
	}
	if (!match && def_connection) {
		struct log_endpoint_info *d;
		for (d = def_connection->nodes; d; d = d->next) {
			if (d->type == EP_DESTINATION) {
				assert(d->ref);
				HANDLE_LOG(d->ref, msg);
			}
		}
	}
	log_info_free(msg);
}

struct log_handler *make_log_center(struct log_connection *connections)
{
	NEW(log_center, self);
	
	self->super.handler = do_distribute_log;
	self->connections = connections;
	return &self->super;
}
