/***************************************************************************
 *
 * Copyright (c) 1999 Balzs Scheidler
 * Copyright (c) 1999 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Inspired by nsyslog, originally written by Darren Reed.
 *
 * $Id: cfg-lex.l,v 1.7 2000/02/17 20:26:53 bazsi Exp $
 *
 ***************************************************************************/
%{

#include "syslog-ng.h"
#include "utils.h"

#include <string.h>
#include <strings.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "cfg-grammar.h"

struct keyword {
	char	*kw_name;
	int	kw_token;
};

static struct keyword keywords[] = {
	/* statements */
	{ "source", 		KW_SOURCE },
	{ "destination",	KW_DESTINATION },
	{ "filter",             KW_FILTER },
	{ "log",		KW_LOG },
	{ "options",		KW_OPTIONS },

	/* option items */
	{ "mark",		KW_MARK_FREQ },
	{ "sync", 		KW_SYNC_FREQ },
	{ "long_hostnames",	KW_CHAIN_HOSTNAMES },
        { "chain_hostnames",    KW_CHAIN_HOSTNAMES },
        { "use_fqdn",           KW_USE_FQDN },
	{ "use_dns",		KW_USE_DNS },
  	{ "gc_threshold",	KW_GC_BUSY_THRESHOLD },
  	{ "gc_busy_threshold",	KW_GC_BUSY_THRESHOLD },
  	{ "gc_idle_threshold",	KW_GC_IDLE_THRESHOLD },
 	{ "time_reopen",	KW_TIME_REOPEN },
	{ "log_fifo_size",	KW_LOG_FIFO_SIZE },
        { "create_dirs",        KW_CREATE_DIRS },
 	{ "localip",		KW_LOCALIP },
	{ "ip",			KW_IP },
	{ "localport",		KW_LOCALPORT },
	{ "port",		KW_PORT },
	{ "destport",		KW_DESTPORT },
	{ "owner",		KW_OWNER },
	{ "group",		KW_GROUP },
	{ "perm",		KW_PERM },
        { "dir_perm",           KW_DIR_PERM },
 	{ "keep-alive",         KW_KEEP_ALIVE },
	{ "max-connections",	KW_MAX_CONNECTIONS },
	{ "mac",		KW_MAC },
	{ "authentication",	KW_AUTH },
	{ "encrypt",		KW_ENCRYPT },
	{ "required",		KW_REQUIRED },
	{ "allow",		KW_ALLOW },
	{ "deny",		KW_DENY },
	{ "compress",		KW_COMPRESS },
       
	/* source or destination items */
	{ "file",		KW_FILE },
        { "fifo",               KW_PIPE },
	{ "pipe",		KW_PIPE },
        { "internal",           KW_INTERNAL },
	{ "unix-dgram",		KW_UNIX_DGRAM },
	{ "unix-stream",	KW_UNIX_STREAM },
        { "udp",                KW_UDP },
        { "tcp",                KW_TCP },
        { "usertty", 		KW_USER },
        { "door",               KW_DOOR },
        { "sun-stream",		KW_SUN_STREAMS },
        { "sun-streams",	KW_SUN_STREAMS },
        { "program",		KW_PROGRAM },

	/* filter items */
        { "or",                 KW_OR },
	{ "and",                KW_AND },
        { "not",                KW_NOT },
	{ "level",              KW_LEVEL },
	{ "priority",           KW_LEVEL },
	{ "facility",           KW_FACILITY },
	{ "program",		KW_PROGRAM },
        { "host",               KW_HOST },
        { "match",		KW_MATCH },

	/* on/off switches */
	{ "yes",		KW_YES },
	{ "on",			KW_YES },
	{ "no",			KW_NO },
	{ "off", 		KW_NO }
};

#define YY_NO_UNPUT   1

#define MAX_REGEXP_LEN	1024

int linenum = 1;
int lex_filter_params = 0;
char buf[MAX_REGEXP_LEN];
char *str;

static int check_reserved_words(char *token);
static void append_string(int length, char *str);
static void append_char(char c);

%}

white	[ \t]
digit	[0-9]
alpha		[a-zA-Z]
alphanum	[a-zA-Z0-9]

%x string
%x qstring
%%

^\#.*$                     ;
\n			   { linenum++; }
{white}+		   ;
\.\.                       { return DOTDOT; }
0x{digit}+ 		   { yylval.num = strtol(yytext, NULL, 16); return NUMBER; }
0{digit}+		   { yylval.num = strtol(yytext, NULL, 8); return NUMBER; }
{digit}+		   { yylval.num = atoi(yytext); return NUMBER; }
[^ \#'"\(\)\{\}\\;\n\t,|]+ { return check_reserved_words(yytext); }
\(	      		   { return '('; }
\)			   { return ')'; }
\;			   { return ';'; }
\{			   { return '{'; }
\}			   { return '}'; }
\|			   { return '|'; }
\,			   { return ','; }

\"                         {
				str = buf;
				/* yy_push_state(string);*/
				BEGIN(string);
			   }
\'			   {
				str = buf;
				BEGIN(qstring);
			   }
<string>\\a		   { append_char(7); }
<string>\\n	   	   { append_char(10); }
<string>\\r		   { append_char(13); }
<string>\\t		   { append_char(9); }
<string>\\v		   { append_char(11); }
<string>\\[^anrtv]	   { append_string(1, yytext + 1); }
<string>\"		   { 
				BEGIN(INITIAL);
				/* yy_pop_state();*/
				yylval.cptr = strdup(buf);
				return STRING; 
		           }
<string>[^"\\]+		   { append_string(strlen(yytext), yytext); }
<qstring>[^']+		   { append_string(strlen(yytext), yytext); }
<qstring>\'		   { 
				BEGIN(INITIAL);
				yylval.cptr = strdup(buf);
				return STRING;
			   }

%%

#if 0
int lex_init(FILE *file)
{
	yyrestart(file);
	linenum = 0;
	return 0;
}
#endif

int check_reserved_words(char *token)
{
	int i;
	
	for (i = 0; i < (sizeof(keywords) / sizeof(struct keyword)); i++) {
		if (strcmp(keywords[i].kw_name, token) == 0) {
			return keywords[i].kw_token;
		}
	}
	yylval.cptr = strdup(token);
	return IDENTIFIER;
}

static void append_string(int length, char *s)
{
	int to_copy = MIN(MAX_REGEXP_LEN - (str - buf) - 1, length);

	memcpy(str, s, to_copy);
	str += to_copy;
	*str = 0;
}

static void append_char(char c)
{
      	*str = c;
	str++;
	*str = 0;
}
