/***************************************************************************
 *
 * Copyright (c) 1999 Balzs Scheidler
 * Copyright (c) 1999 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Inspired by nsyslog, originally written by Darren Reed.
 *
 * $Id: cfgfile.h,v 1.16.2.1 2000/03/24 10:57:28 bazsi Exp $
 *
 ***************************************************************************/

#ifndef __CFGFILE_H_INCLUDED
#define __CFGFILE_H_INCLUDED

#include "sources.h"
#include "filters.h"
#include "destinations.h"
#include "center.h"

#define CLASS_DECLARE
#include "cfgfile.h.x"
#undef CLASS_DECLARE

/* CLASS:
    (class
      (name syslog_config)
      (vars
        (init method int "struct persistent_config *")
	(destroy method int "struct persistent_config *")
	(resources object resource_list)
        (backend object io_backend)
	; global options
	(chain_hostnames simple UINT32)
	(keep_hostname simple UINT32)
	(mark_freq simple UINT32)
	(sync_freq simple UINT32)
	(time_reopen simple UINT32)
	(log_fifo_size simple UINT32)
	(use_fqdn simple UINT32)
	(use_dns simple UINT32)
	(create_dirs simple UINT32)
	(gc_busy_threshold simple UINT32)
	(gc_idle_threshold simple UINT32)
	; internal messages should come from this source
	(internal object log_handler)
        (sources object log_source_group)
        (filters object log_filter)
        (destinations object log_dest_group)
	; connections between sources and destinations
        (connections object log_connection))) 
*/

#define CONFIG_INIT(c, p) (c)->init(c, p)
#define CONFIG_DESTROY(c, p) (c)->destroy(c, p)

/* CLASS:
   (class 
     (name persistent_info)
     (vars
       (name string)
       (o object ol_object)
       (kill pointer (function void "struct ol_string *name" "struct ol_object *o"))
       (next object persistent_info)))
*/

struct persistent_info *
make_persistent_info(struct ol_string *name, 
		     struct ol_object *o, 
		     void (*kill)(struct ol_string *name, struct ol_object *obj));

/* info needed to kept persistent upon restart */
/* CLASS:
   (class
     (name persistent_config)
     (vars
       (nodes object persistent_info)))
*/

struct persistent_info *find_persistent_info(struct persistent_config *p, UINT32 length, const char *name);

void add_persistent_info(struct persistent_config *p, struct persistent_info *node);

void kill_persistent_config(struct persistent_config *persistent);

struct persistent_config *make_persistent_config(void);

extern struct syslog_config *configuration;

void add_dest_group(struct log_dest_group *grp);
void add_source_group(struct log_source_group *grp);
void add_log_connection(struct log_connection *conn);
void add_filter_rule(struct log_filter *filter);

struct syslog_config *make_syslog_config(const char *name, struct io_backend *backend);

#endif
