/***************************************************************************
 *
 * Copyright (c) 2001 BalaBit IT Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: klogctl.c,v 1.2 2001/01/24 18:04:48 bazsi Exp $
 *
 ***************************************************************************/

#include <sys/klog.h>
#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>

void usage(void)
{
	printf("Usage: klogctl [options]\n"
	       "Set kernel logging parameters.\n\n"
	       "Options:\n"
	       "  -n, --log-level     Specify log level of your kernel (klogd default is 6)\n"
	       "  -f, --clear         Clear kernel ring buffer\n");
}

int main(int argc, char *argv[])
{
	struct option klogctl_options[] = {
		{ "log-level", required_argument, NULL, 'n' },
		{ "clear", no_argument, NULL, 'f' },
		{ NULL, 0, NULL, 0 }
	};

	int log_level = 6; /* compatible with klogd's default */
	int rc = 0;
	int opt;

	while ((opt = getopt_long(argc, argv, "n:f", klogctl_options, NULL)) != -1) {
		switch (opt)
		{
		case 'n':
			log_level = atoi(optarg);
			rc = klogctl(8, NULL, log_level);
			break;
		case 'f':
			rc = klogctl(5, NULL, 0);
			break;
		default:
			usage();
			break;
		}
	}
	if (optind != argc) {
		usage();
	}
	if (rc == -1) {
		printf("Error in klogctl(): %m\n");
	}
	return 0;
}
