/***************************************************************************
 *
 * Copyright (c) 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Inspired by nsyslog, originally written by Darren Reed.
 *
 * $Id: macros.h,v 1.2 2003/04/10 10:51:00 bazsi Exp $
 *
 ***************************************************************************/

#ifndef __MACROS_H
#define __MACROS_H

#define M_FACILITY 0
#define M_LEVEL    1
#define M_TAG      2

#define M_DATE     3
#define M_FULLDATE 4
#define M_ISODATE  5
#define M_YEAR     6
#define M_MONTH    7
#define M_DAY      8
#define M_HOUR     9
#define M_MIN      10
#define M_SEC      11
#define M_WEEKDAY  12
#define M_TZOFFSET 13
#define M_TZ       14
#define M_UNIXTIME 15

#define M_DATE_RECVD     16
#define M_FULLDATE_RECVD 17
#define M_ISODATE_RECVD  18
#define M_YEAR_RECVD     19
#define M_MONTH_RECVD    20
#define M_DAY_RECVD      21
#define M_HOUR_RECVD     22
#define M_MIN_RECVD      23
#define M_SEC_RECVD      24
#define M_WEEKDAY_RECVD  25
#define M_TZOFFSET_RECVD 26
#define M_TZ_RECVD       27
#define M_UNIXTIME_RECVD 28

#define M_DATE_STAMP     30
#define M_FULLDATE_STAMP 31
#define M_ISODATE_STAMP  32
#define M_YEAR_STAMP     33
#define M_MONTH_STAMP    34
#define M_DAY_STAMP      35
#define M_HOUR_STAMP     36
#define M_MIN_STAMP      37
#define M_SEC_STAMP      38
#define M_WEEKDAY_STAMP  39
#define M_TZOFFSET_STAMP 40
#define M_TZ_STAMP       41
#define M_UNIXTIME_STAMP 42

#define M_FULLHOST       43
#define M_HOST           44
#define M_FULLHOST_FROM  45
#define M_HOST_FROM      46
#define M_PROGRAM        47

#define M_MESSAGE        48

#define M_SOURCE_IP      49

struct ol_string *
expand_macros(struct syslog_config *cfg, struct ol_string *template, int template_escape, struct log_info *msg);

#endif
