/* 
   Copyright (c) 1995 by Cisco systems, Inc.
   All rights reserved.

   Please NOTE:  None of the TACACS code available here comes with any
   warranty or support.
*/

#include "tac_plus.h"

/*
 *  Come here when we receive an Start Accounting packet
 */

void account();

void
accounting(pak)
u_char *pak;
{
    struct acct *acct_pak;
    HDR *hdr;
    u_char *read_packet();

    if (debug & DEBUG_ACCT_FLAG)
	report(LOG_DEBUG, "Start accounting request");

    while (1) {

	account(pak);

	acct_pak = (struct acct *) (pak + TAC_PLUS_HDR_SIZE);

	if (!(acct_pak->flags & TAC_PLUS_ACCT_FLAG_MORE)) 
	    break;

	if (debug & DEBUG_ACCT_FLAG)
	    report(LOG_DEBUG, "More bit is set");
	
	free(pak); /* free previous packet */

	pak = read_packet();
	if (!pak) {
	    report(LOG_ERR, 
		   "%s: Empty packet read when expecting more accounting records",
		   session.peer);
	    return;
	}

	if (debug & DEBUG_PACKET_FLAG)
	    dump_nas_pak(pak);

	hdr = (HDR *) pak;

	if (hdr->type != TAC_PLUS_ACCT) {
	    report(LOG_ERR, 
		   "%s: Bad hdr type %d while expecting more accounting records",
		   session.peer,
		   hdr->type);
	    break;
	}
    }
    free(pak);
}

void
account(pak)
u_char *pak;
{
    struct acct *acct_pak;
    u_char *p, *argsizep;
    struct acct_rec rec;
    struct identity identity;
    char **cmd_argp;
    int i, status;

    acct_pak = (struct acct *) (pak + TAC_PLUS_HDR_SIZE);

    /* Fill out accounting record structure */
    bzero(&rec, sizeof(struct acct_rec));

    if (acct_pak->flags & TAC_PLUS_ACCT_FLAG_WATCHDOG)
	rec.acct_type = ACCT_TYPE_UPDATE;
    if (acct_pak->flags & TAC_PLUS_ACCT_FLAG_START)
	rec.acct_type = ACCT_TYPE_START;
    if (acct_pak->flags & TAC_PLUS_ACCT_FLAG_STOP)
	rec.acct_type = ACCT_TYPE_STOP;

    rec.authen_method  = acct_pak->authen_method;
    rec.authen_type    = acct_pak->authen_type;
    rec.authen_service = acct_pak->authen_service;

    /* start of variable length data is here */
    p = pak + TAC_PLUS_HDR_SIZE + TAC_ACCT_REQ_FIXED_FIELDS_SIZE;

    /* skip arg cnts */
    p += acct_pak->arg_cnt;

    /* zero out identity struct so that all strings can be NULL terminated */
    bzero(&identity, sizeof(struct identity));

    bcopy(p, identity.username,
	  MIN((int)acct_pak->user_len, NAS_USERNAME_SIZE - 1));
    p += acct_pak->user_len;

    /* identity.NAS_name[32] */
    bcopy(session.peer,
	  identity.NAS_name,
	  MIN((int)strlen(session.peer), NAS_NAME_SIZE - 1));

    /* identity.NAS_port[32] */
    bcopy(p, identity.NAS_port,
	  MIN((int)acct_pak->port_len, NAS_PORT_SIZE - 1));
    p += acct_pak->port_len;

    /* identity.NAC_address[64] */
    bcopy(p, identity.NAC_address,
	  MIN((int)acct_pak->rem_addr_len, NAS_ADDR_SIZE - 1));
    p += acct_pak->rem_addr_len;

    identity.priv_lvl = acct_pak->priv_lvl;

    rec.identity = &identity;

    /* Now process cmd args */
    argsizep = pak + TAC_PLUS_HDR_SIZE + TAC_ACCT_REQ_FIXED_FIELDS_SIZE;

    cmd_argp = (char **) tac_malloc(acct_pak->arg_cnt * sizeof(char *));

    for (i = 0; i < (int)acct_pak->arg_cnt; i++) {
	cmd_argp[i] = tac_make_string(p, *argsizep);
	p += *argsizep++;
    }

    rec.args = cmd_argp;
    rec.num_args = acct_pak->arg_cnt;

    status = do_acct(&rec);
    send_acct_reply(status, rec.msg, rec.admin_msg);

    for (i = 0; i < (int)acct_pak->arg_cnt; i++) {
	free(cmd_argp[i]);
    }    
    free(cmd_argp);
    
    if (rec.msg)
	free(rec.msg);
    if (rec.admin_msg)
	free(rec.admin_msg);
}
