/* 
   Copyright (c) 1995 by Cisco systems, Inc.
   All rights reserved.

   Please NOTE:  None of the TACACS code available here comes with any
   warranty or support.
*/

#include "tac_plus.h"

/*
 *  Come here when we receive an authorization START packet
 */

void
author(pak)
u_char *pak;
{
    struct author *apak;
    struct identity identity;
    struct author_data author_data;
    u_char *p;
    u_char *argsizep;
    char **cmd_argp;
    int i;

    if (debug & DEBUG_AUTHOR_FLAG)
	report(LOG_DEBUG, "Start authorization request");

    apak = (struct author *) (pak + TAC_PLUS_HDR_SIZE);

    /* start of variable length data is here */
    p = pak + TAC_PLUS_HDR_SIZE + TAC_AUTHOR_REQ_FIXED_FIELDS_SIZE;

    /* arg length data starts here */
    argsizep = p;

    p += apak->arg_cnt;

    bzero(&author_data, sizeof(struct author_data));

    /* The identity structure */

    /* zero out identity struct so that all strings can be NULL terminated */
    bzero(&identity, sizeof(struct identity));

    bcopy(p, identity.username,
	  MIN((int)apak->user_len, NAS_USERNAME_SIZE - 1));
    p += apak->user_len;

    /* identity.NAS_name[32] */
    bcopy(session.peer,
	  identity.NAS_name,
	  MIN((int)strlen(session.peer), NAS_NAME_SIZE - 1));

    /* identity.NAS_port[32] */
    bcopy(p, identity.NAS_port,
	  MIN((int)apak->port_len, NAS_PORT_SIZE - 1));
    p += apak->port_len;

    /* identity.NAC_address[64] */
    bcopy(p, identity.NAC_address,
	  MIN((int)apak->rem_addr_len, NAS_ADDR_SIZE - 1));
    p += apak->rem_addr_len;

    identity.priv_lvl = apak->priv_lvl;

    /* The author_data structure */

    author_data.id = &identity;	/* user id */

    /* FIXME: validate these fields */
    author_data.authen_method = apak->authen_method;
    author_data.authen_type = apak->authen_type;
    author_data.service = apak->service;
    author_data.num_in_args = apak->arg_cnt;

    /* Space for args + NULL */
    cmd_argp = (char **) tac_malloc(apak->arg_cnt * sizeof(char *));

    /* p  points to the start of args. Step thru them making strings */
    for (i = 0; i < (int)apak->arg_cnt; i++) {
	cmd_argp[i] = tac_make_string(p, *argsizep);
	p += *argsizep++;
    }

    author_data.input_args = cmd_argp;	/* input command arguments */

    if (do_author(&author_data)) {
	report(LOG_ERR, "%s: do_author returned an error", session.peer);
	send_author_reply(AUTHOR_STATUS_ERROR,
			  author_data.msg,
			  author_data.admin_msg,
			  author_data.num_out_args,
			  author_data.output_args);
	return;
    }

    /* Send a reply packet */
    send_author_reply(author_data.status,
		      author_data.msg,
		      author_data.admin_msg,
		      author_data.num_out_args,
		      author_data.output_args);

    if (debug)
	report(LOG_INFO, "authorization query for '%s' %s from %s %s",
	       author_data.id->username  && author_data.id->username[0] ?
	       author_data.id->username : "unknown",
	       author_data.id->NAS_port && author_data.id->NAS_port[0] ?
	       author_data.id->NAS_port : "unknown",
	       session.peer,
	       (author_data.status == AUTHOR_STATUS_PASS_ADD ||
		author_data.status == AUTHOR_STATUS_PASS_REPL) ?
	       "accepted" : "rejected");

    /* free the input args */
    if (author_data.input_args) {
	for (i = 0; i < author_data.num_in_args; i++)
	    free(author_data.input_args[i]);
	
	free(author_data.input_args);
	author_data.input_args = NULL;
    }

    /* free the output args */
    if (author_data.output_args) {
	for (i=0; i < author_data.num_out_args; i++)
	    free(author_data.output_args[i]);

	free(author_data.output_args);
	author_data.output_args = NULL;
    }

    if (author_data.msg)
	free(author_data.msg);

    if (author_data.admin_msg)
	free(author_data.admin_msg);
}
