/* 
   Copyright (c) 1995 by Cisco systems, Inc.
   All rights reserved.

   Please NOTE:  None of the TACACS code available here comes with any
   warranty or support.
*/

#include "tac_plus.h"

static int acctfd = 0;

/* Make a acct entry into the accounting file for accounting. 
   Return 1 on error  */

static int
acct_write(string)
    char *string;
{
    if (write(acctfd, string, strlen(string)) != strlen(string)) {
	report(LOG_ERR, "%s: couldn't write acct file %s %s",
	       session.peer,
	       session.acctfile, sys_errlist[errno]);
	return(1);
    }
    
    if (debug & DEBUG_ACCT_FLAG)
	report(LOG_DEBUG, "'%s'", string);

    return(0);
}

/* Write a string or "unknown" into the accounting file.
   Return 1 on error  */
static int
acct_write_field(string)
    char *string;
{
    if (string && string[0]) {
	if (acct_write(string))
	    return(1);
    } else {
	if (acct_write("unknown"))
	    return(1);
    }
    return(0);
}

int
do_acct(rec)
struct acct_rec *rec;
{
    int i, status;
    time_t t = time(NULL);
    char *ct = ctime(&t);

    ct[24] = '\0';

    if (!acctfd) {
	acctfd = open(session.acctfile, O_CREAT | O_WRONLY | O_APPEND, 0666);
	if (acctfd < 0) {
	    report(LOG_ERR, "Can't open acct file %s -- %s",
		   session.acctfile, sys_errlist[errno]);
	    return(1);
	}
    }
    if (!tac_lockfd(session.acctfile, acctfd)) {
	rec->admin_msg = tac_strdup("Cannot lock log file");
	report(LOG_ERR, "%s: Cannot lock %s", 
	       session.peer, session.acctfile);
	return(1);
    }

    status = 0;

    status += acct_write(ct);
    status += acct_write("\t");

    status += acct_write_field(rec->identity->NAS_name);
    status += acct_write("\t");

    status += acct_write_field(rec->identity->username);
    status += acct_write("\t");

    status += acct_write_field(rec->identity->NAS_port);
    status += acct_write("\t");

    status += acct_write_field(rec->identity->NAC_address);
    status += acct_write("\t");

    switch(rec->acct_type) {
    case ACCT_TYPE_UPDATE:
	status += acct_write("update\t");
	break;
    case ACCT_TYPE_START:
	status += acct_write("start\t");
	break;
    case ACCT_TYPE_STOP:
	status += acct_write("stop\t");
	break;
    default:
	status += acct_write("unknown\t");
	break;
    }

    for (i=0; i < rec->num_args; i++) {
	status += acct_write(rec->args[i]);
	if (i < (rec->num_args-1)) 
	    status += acct_write("\t");
    }
    status += acct_write("\n");

    close(acctfd);
    acctfd = 0;

    if (status) {
	return(1);
    }
    return (0);
}

