/* 
   Copyright (c) 1995 by Cisco systems, Inc.
   All rights reserved.

   Please NOTE:  None of the TACACS code available here comes with any
   warranty or support.
*/

/* Tacacs+ password lookup routine for those systems which don't have
   setpwfile. Not for use on /etc/passwd files */

#include "tac_plus.h"
#include <pwd.h>
#include <string.h>

static struct passwd pw_passwd;

struct passwd *
tac_passwd_lookup(name, file)
    char *name, *file;
{
    FILE *passwd_fp = NULL;

    static char uname[512];
    static char password[1024];
    static char gecos[1024];
    static char homedir[1024];
    static char shell[1024];
    char buf[1024];
    char *s, *e;

    passwd_fp = fopen(file, "r");

    if (passwd_fp) {
	if (debug & DEBUG_PASSWD_FLAG)
	    report(LOG_DEBUG, "tac_passwd_lookup: open %s %d", 
		   file, fileno(passwd_fp));
    } else {
	report(LOG_ERR, "tac_passwd_lookup: cannot open file %s for reading", 
	       file);
	return(NULL);
    }

    while (fgets(buf, sizeof(buf), passwd_fp)) {

	/* uname, password, uid, gid, gecos, homedir, shell */

	s = buf;
	e = index(buf, ':');
	if (!e)
	    break;

	strncpy(uname, s, e - s);
	uname[e - s] = '\0';

	/* try next entry */
	if (strcmp(uname, name))
	    continue;

	s = e + 1;
	e = index(s, ':');
	if (!e) {
	    break;
	}
	strncpy(password, s, e - s);
	password[e - s] = '\0';

	s = e + 1;
	e = index(s, ':');
	if (!e) {
	    break;
	}
	pw_passwd.pw_uid = atoi(s);

	s = e + 1;
	e = index(s, ':');
	pw_passwd.pw_gid = atoi(s);

	s = e + 1;
	e = index(s, ':');
	if (!e) {
	    break;
	}
	strncpy(gecos, s, e - s);
	gecos[e - s] = '\0';

	s = e + 1;
	e = index(s, ':');
	if (!e) {
	    break;
	}
	strncpy(homedir, s, e - s);
	homedir[e - s] = '\0';

	s = e + 1;
	e = index(s, '\n');
	if (!e) {
	    break;
	}
	strncpy(shell, s, e - s);
	shell[e - s] = '\0';

        pw_passwd.pw_name    = uname;
        pw_passwd.pw_passwd  = password;
#ifndef NO_PWAGE
        pw_passwd.pw_age     = NULL;
        pw_passwd.pw_comment = NULL;
#endif /* NO_PWAGE */
        pw_passwd.pw_gecos   = gecos;
        pw_passwd.pw_dir     = homedir;
        pw_passwd.pw_shell   = shell;

	if (debug & DEBUG_PASSWD_FLAG)
	    report(LOG_DEBUG, "tac_passwd_lookup: close %s %d", 
		   file, fileno(passwd_fp));
	fclose(passwd_fp);
	return(&pw_passwd);
    }

    /* no match found */
    if (debug & DEBUG_PASSWD_FLAG)
	    report(LOG_DEBUG, "tac_passwd_lookup: close %s %d", 
		   file, fileno(passwd_fp));
    fclose(passwd_fp);
    return(NULL);
}
