/* 
   Copyright (c) 1995 by Cisco systems, Inc.
   All rights ved.

   Please NOTE:  None of the TACACS code available here comes with any
   warranty or support.
*/

#include "tac_plus.h"
#include <stdio.h>

#ifdef AIX
#include <sys/types.h>
#else
#include <time.h>
#endif

#ifdef __STDC__
#include <stdarg.h>		/* ANSI C, variable length args */
#else
#include <varargs.h>		/* has 'vararg' definitions */
#endif

FILE *ostream = NULL;

#define LOGFILE "/var/tmp/tac_plus.log"

/* report:
 *
 * This routine reports errors and such via stderr and syslog() if
 * appopriate.  It just helps avoid a lot of if-else in the code.
 *
 * LOG_DEBUG messages are ignored unless debugging is on.
 * All other priorities are always logged to syslog.
 */

#ifdef __STDC__
void
report(int priority, char *fmt,...)
#else
/* VARARGS2 */
void
report(priority, fmt, va_alist)
int priority;
char *fmt;

va_dcl				/* no terminating semi-colon */
#endif
{
    char msg[256];		/* temporary string */
    va_list ap;

#ifdef __STDC__
    va_start(ap, fmt);
#else
    va_start(ap);
#endif
    vsprintf(msg, fmt, ap);
    va_end(ap);

    if (console) {
	extern int errno;
	
	if (!ostream)
	    ostream = fopen("/dev/console", "w");

	if (ostream) {
	    if (priority == LOG_ERR)
		fprintf(ostream, "Error ");
	    fprintf(ostream, "%s\n", msg);
	}
	else 
	    syslog(LOG_ERR, "Cannot open /dev/console errno=%d", errno);
    }

    if (debug) {
	int logfd;

	logfd = open(LOGFILE, O_CREAT | O_WRONLY | O_APPEND, 0666);
	if (logfd >= 0) {
	    char buf[512];
	    time_t t = time(NULL);
	    char *ct = ctime(&t);

	    ct[24] = '\0';
	    tac_lockfd(LOGFILE, logfd);
	    sprintf(buf, "%s [%d]: ", ct, getpid());
	    write(logfd, buf, strlen(buf));
	    if (priority == LOG_ERR)
		write(logfd, "Error ", 6);
	    write(logfd, msg, strlen(msg));
	    write(logfd, "\n", 1);
	    close(logfd);
	}
    }

    if (single) {
	fprintf(stderr, "%s\n", msg);
    }

    if (priority == LOG_DEBUG)
	return;

    if (priority == LOG_ERR)
	syslog(priority, "Error %s", msg);
    else
	syslog(priority, "%s", msg);
}

/* format a hex dump for syslog */
void
report_hex(priority, p, len)
u_char *p;
int len;
{
    char buf[256];
    char digit[10];
    int buflen;
    int i;
    
    if (len <= 0)
	return;

    buf[0] = '\0';
    buflen = 0;
    for (i = 0; i < len && i < 255; i++, p++) {

	sprintf(digit, "0x%x ", *p);
	strcat(buf, digit);
	buflen += strlen(digit);

	if (buflen > 75) {
	    report(priority, "%s", buf);
	    buf[0] = '\0';
	    buflen = 0;
	}
    }

    if (buf[0]) {
	report(priority, "%s", buf);
    }
}


/* format a non-null terminated string for syslog */
void
report_string(priority, p, len)
u_char *p;
int len;
{
    char buf[256];
    char *bufp = buf;
    int i;

    if (len <= 0)
	return;

    for (i = 0; i < len && i < 255; i++) {
	if (32 <= *p && *p <= 126) {
	    *bufp++ = *p++;
	} else {
	    sprintf(bufp, "0x%x", *p);
	    bufp += strlen(bufp);
	    p++;
	}
    }
    *bufp = '\0';
    report(priority, "%s", buf);
}

void
regerror(s)
char *s;
{
    report(LOG_ERR, "in regular expression %s", s);
}

