/* 
   Copyright (c) 1995 by Cisco systems, Inc.
   All rights reserved.

   Please NOTE:  None of the TACACS code available here comes with any
   warranty or support.
*/

#include "tac_plus.h"

#ifdef STDLIB_MALLOC

#include <stdlib.h>

#else /* !STDLIB_MALLOC */

#include <malloc.h>

#endif /* STDLIB_MALLOC */

char *
tac_malloc(size)
int size;
{
    char *p = (char *) malloc(size);

    if (p == NULL) {
	report(LOG_ERR, "malloc %d failure", size);
	tac_exit(1);
    }
    return (p);
}

tac_exit(status)
int status;
{
    if (debug & DEBUG_FORK_FLAG)
	report(LOG_DEBUG, "exit status=%d", status);
    exit(status);
}

char *
tac_strdup(p)
char *p;
{
    char *n = strdup(p);

    if (n == NULL) {
	report(LOG_ERR, "strdup allocation failure");
	tac_exit(1);
    }
    return (n);
}

char *
tac_make_string(p, len)
u_char *p;
int len;
{
    char *string;
    int new_len = len;

    /* Add space for a null terminator if needed */
    if (p[len - 1])
	new_len++;

    string = (char *) tac_malloc(new_len);

    bzero(string, new_len);
    bcopy(p, string, len);
    return (string);
}

/* return a pointer to the end of substring in string, or NULL. Substring 
   must begin at start of string.
*/
char *
tac_find_substring(substring, string)
char *substring, *string;
{
    int len;

    if (!(substring && string)) {
	return(NULL);
    }

    len = strlen(substring);

    if (len > (int) strlen(string)) {
	return(NULL);
    }
	
    if (strncmp(substring, string, len)) {
	/* no match */
	return(NULL);
    }
    return(string + len);
}

#ifdef NEED_BZERO
int
bzero(p, len)
    register char *p;
    int len;
{
    register int n;

    if ((n = len) <= 0)
	return;
    do
	*p++ = 0;
    while (--n);
}

int
bcopy(s1, s2, len)
    register char *s1, *s2;
    int len;
{
    register int n;

    if ((n = len) <= 0)
	return;
    do
	*s2++ = *s1++;
    while (--n);
}
#endif /* NEED_BZERO */

/* Lock a file descriptor using fcntl. Returns 1 on successfully
   acquiring the lock. The lock dies when we close the file, so
   there's currently no separate unlock procedure.

   Note that if the locked file is on an NFS-mounted partition, you
   are at the mercy of SUN's lockd, which is probably a bad idea */

#include <unistd.h>

int
tac_lockfd(filename,lockfd)
char *filename;
int lockfd;
{
    int tries;
    struct flock flock;

    flock.l_type   = F_WRLCK;
    flock.l_whence = SEEK_SET; /* relative to bof */
    flock.l_start  = 0L; /* from offset zero */
    flock.l_len    = 0L; /* lock to eof */

    for (tries = 0; tries < 10; tries++) {
	errno = 0;
	if (fcntl(lockfd, F_SETLK, &flock) < 0) {
	    if (errno == EACCES || errno == EAGAIN) {
		sleep(1);
		continue;
	    } else {
		report(LOG_ERR, "fcntl lock error on %s %d %s", 
		       filename, lockfd, sys_errlist[errno]);
		return(0);
	    }
	}
	/* successful lock */
	break;
    }

    if (errno != 0) {
	report(LOG_ERR, "Cannot lock %s fd %d in %d tries %s", 
	       filename, lockfd, tries+1, sys_errlist[errno]);
	return(0);
    }
    return(1);
}

